import { Component, ElementRef, Renderer, ContentChildren, Input, trigger, style, transition, animate, state } from '@angular/core';
import { ACTIONS, arrowKeysHandler } from './actions';
import { Ng2MenuItem } from '../menu-item/ng2-menu-item';
import { DropdownStateService } from '../../services/dropdown-state.service';
export var Ng2DropdownMenu = (function () {
    function Ng2DropdownMenu(state, element, renderer) {
        this.state = state;
        this.element = element;
        this.renderer = renderer;
        this.width = 4;
        this.focusFirstElement = true;
    }
    Ng2DropdownMenu.prototype.show = function () {
        this.renderer.setElementStyle(this.getMenuElement(), 'display', 'block');
        this.state.menuState.isVisible = true;
        if (this.focusFirstElement) {
            this.state.dropdownState.select(this.items.first, false);
        }
        window.addEventListener('keydown', arrowKeysHandler, false);
    };
    Ng2DropdownMenu.prototype.hide = function () {
        this.state.menuState.isVisible = false;
        this.renderer.setElementStyle(this.getMenuElement(), 'display', 'none');
        this.state.dropdownState.unselect();
        window.removeEventListener('keydown', arrowKeysHandler, false);
    };
    Ng2DropdownMenu.prototype.updatePosition = function (position) {
        this.position = position;
        this.ngDoCheck();
    };
    Ng2DropdownMenu.prototype.handleKeypress = function ($event) {
        if (this.state.menuState.isVisible === false) {
            return;
        }
        var key = $event.keyCode, items = this.items.toArray(), index = items.indexOf(this.state.dropdownState.selectedItem);
        if (!ACTIONS.hasOwnProperty(key)) {
            return;
        }
        ACTIONS[key].call(this, index, items, this.state.dropdownState);
        $event.preventDefault();
        $event.stopPropagation();
    };
    Ng2DropdownMenu.prototype.getMenuElement = function () {
        return this.element.nativeElement.children[0];
    };
    Ng2DropdownMenu.prototype.calcPositionOffset = function (position) {
        if (!position) {
            return;
        }
        var supportPageOffset = window.pageXOffset !== undefined;
        var isCSS1Compat = ((document.compatMode || '') === 'CSS1Compat');
        var x = supportPageOffset ? window.pageXOffset : isCSS1Compat ?
            document.documentElement.scrollLeft : document.body.scrollLeft;
        var y = supportPageOffset ? window.pageYOffset : isCSS1Compat ?
            document.documentElement.scrollTop : document.body.scrollTop;
        var _a = this.applyOffset((position.top + y - 15) + "px", (position.left + x - 5) + "px"), top = _a.top, left = _a.left;
        var element = this.getMenuElement(), clientWidth = element.clientWidth, clientHeight = element.clientHeight, marginFromBottom = parseInt(top) + clientHeight, marginFromRight = parseInt(left) + clientWidth, windowScrollHeight = window.innerHeight + window.scrollY, windowScrollWidth = window.innerWidth + window.scrollX;
        if (marginFromBottom >= windowScrollHeight) {
            top = (parseInt(top.replace('px', '')) - clientHeight) + "px";
        }
        if (marginFromRight >= windowScrollWidth) {
            var marginRight = marginFromRight - windowScrollWidth + 30;
            left = (parseInt(left.replace('px', '')) - marginRight) + "px";
        }
        return { top: top, left: left };
    };
    Ng2DropdownMenu.prototype.applyOffset = function (top, left) {
        if (!this.offset) {
            return { top: top, left: left };
        }
        var offset = this.offset.split(' ');
        if (!offset[1]) {
            offset[1] = '0';
        }
        top = (parseInt(top.replace('px', '')) + parseInt(offset[0])) + "px";
        left = (parseInt(left.replace('px', '')) + parseInt(offset[1])) + "px";
        return { top: top, left: left };
    };
    Ng2DropdownMenu.prototype.ngOnInit = function () {
        var body = document.querySelector('body');
        body.appendChild(this.element.nativeElement);
        this.listener = this.renderer.listen(body, 'keyup', this.handleKeypress.bind(this));
    };
    Ng2DropdownMenu.prototype.ngDoCheck = function () {
        if (this.state.menuState.isVisible && this.position) {
            var element = this.getMenuElement();
            var position = this.calcPositionOffset(this.position);
            if (position) {
                this.renderer.setElementStyle(element, 'top', position.top);
                this.renderer.setElementStyle(element, 'left', position.left);
            }
        }
    };
    Ng2DropdownMenu.prototype.ngOnDestroy = function () {
        var elem = this.element.nativeElement;
        elem.parentNode.removeChild(elem);
        if (this.listener) {
            this.listener();
        }
    };
    Ng2DropdownMenu.decorators = [
        { type: Component, args: [{
                    selector: 'ng2-dropdown-menu',
                    styleUrls: ['./style.scss'],
                    templateUrl: './template.html',
                    animations: [
                        trigger('fade', [
                            state('visible', style({
                                maxHeight: '400px',
                                opacity: 1
                            })),
                            state('hidden', style({
                                maxHeight: '0',
                                opacity: 0
                            })),
                            transition('visible => hidden', [
                                animate('250ms ease-out')
                            ]),
                            transition('hidden => visible', [
                                animate('300ms cubic-bezier(0.55, 0, 0.55, 0.2)')
                            ])
                        ])
                    ]
                },] },
    ];
    Ng2DropdownMenu.ctorParameters = [
        { type: DropdownStateService, },
        { type: ElementRef, },
        { type: Renderer, },
    ];
    Ng2DropdownMenu.propDecorators = {
        'width': [{ type: Input },],
        'focusFirstElement': [{ type: Input },],
        'offset': [{ type: Input },],
        'items': [{ type: ContentChildren, args: [Ng2MenuItem,] },],
    };
    return Ng2DropdownMenu;
}());
//# sourceMappingURL=ng2-dropdown-menu.js.map