"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('@angular/core');
var pop_over_component_1 = require("./pop-over.component");
var rxjs_1 = require("rxjs");
var PopOverTrigger = (function () {
    function PopOverTrigger(elRef, renderer) {
        this.elRef = elRef;
        this.renderer = renderer;
    }
    PopOverTrigger.prototype.ngOnInit = function () {
    };
    PopOverTrigger.prototype.ngOnChanges = function (changes) {
        if (changes.hasOwnProperty('showOn')) {
            this.setShowOn();
        }
        ;
        if (changes.hasOwnProperty('hideOn')) {
            this.setHideOn();
        }
        ;
    };
    PopOverTrigger.prototype.setHideOn = function () {
        var _this = this;
        if (this.popover) {
            if (this.hideOn) {
                this.popover.hideOn = rxjs_1.Observable.merge.apply(rxjs_1.Observable, this.hideOn.split(',')
                    .map(function (eventType) { return eventType.trim(); })
                    .map(function (eventType) { return rxjs_1.Observable.fromEvent(_this.elRef.nativeElement, eventType); }));
            }
            else {
                this.popover.hideOn = rxjs_1.Observable.empty();
            }
        }
    };
    PopOverTrigger.prototype.setShowOn = function () {
        var _this = this;
        if (this.popover) {
            if (this.showOn) {
                this.popover.showOn = rxjs_1.Observable.merge.apply(rxjs_1.Observable, this.showOn.split(',')
                    .map(function (eventType) { return eventType.trim(); })
                    .map(function (eventType) { return rxjs_1.Observable.fromEvent(_this.elRef.nativeElement, eventType); }));
            }
            else {
                this.popover.showOn = rxjs_1.Observable.empty();
            }
        }
    };
    __decorate([
        core_1.Input('pop-over-trigger'), 
        __metadata('design:type', pop_over_component_1.PopOverComponent)
    ], PopOverTrigger.prototype, "popover", void 0);
    __decorate([
        core_1.Input('show-on'), 
        __metadata('design:type', String)
    ], PopOverTrigger.prototype, "showOn", void 0);
    __decorate([
        core_1.Input('hide-on'), 
        __metadata('design:type', String)
    ], PopOverTrigger.prototype, "hideOn", void 0);
    PopOverTrigger = __decorate([
        core_1.Directive({
            selector: '[pop-over-trigger]'
        }), 
        __metadata('design:paramtypes', [core_1.ElementRef, core_1.Renderer])
    ], PopOverTrigger);
    return PopOverTrigger;
}());
exports.PopOverTrigger = PopOverTrigger;

//# sourceMappingURL=pop-over-trigger.directive.js.map
