"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('@angular/core');
var Rx_1 = require('rxjs/Rx');
var PopOverComponent = (function () {
    function PopOverComponent(elRef, renderer) {
        this.elRef = elRef;
        this.renderer = renderer;
        this.anchorTo = false;
        this.xOffset = 0;
        this.yOffset = 0;
        this.visible$ = new Rx_1.BehaviorSubject(false);
    }
    Object.defineProperty(PopOverComponent.prototype, "showOn", {
        set: function (value) {
            this.showOnSubscription && this.showOnSubscription.unsubscribe();
            value && (this.showOnSubscription = value.subscribe(this.show.bind(this)));
        },
        enumerable: true,
        configurable: true
    });
    ;
    Object.defineProperty(PopOverComponent.prototype, "hideOn", {
        set: function (value) {
            this.hideOnSubscription && this.hideOnSubscription.unsubscribe();
            value && (this.hideOnSubscription = value.subscribe(this.hide.bind(this)));
        },
        enumerable: true,
        configurable: true
    });
    ;
    PopOverComponent.prototype.ngOnInit = function () {
    };
    PopOverComponent.prototype.ngOnDestroy = function () {
        this.hideOnSubscription && this.hideOnSubscription.unsubscribe();
        this.showOnSubscription && this.showOnSubscription.unsubscribe();
    };
    PopOverComponent.prototype.ngAfterViewInit = function () {
        this.renderer.setElementStyle(this.content.nativeElement, 'opacity', '0');
        this.renderer.setElementStyle(this.content.nativeElement, 'visibility', 'hidden');
        return undefined;
    };
    PopOverComponent.prototype.isPosition = function (parts, type) {
        return parts.indexOf(type) >= 0;
    };
    PopOverComponent.prototype.computeAtPosition = function (target, position, xOffset, yOffset) {
        if (xOffset === void 0) { xOffset = 0; }
        if (yOffset === void 0) { yOffset = 0; }
        var x;
        var y;
        var positionParts = (position || '').split(/\s+/);
        if (positionParts.length > 2) {
            console.warn('bad position: ', position);
        }
        var targetPosition = target.getBoundingClientRect();
        if (this.isPosition(positionParts, 'left')) {
            x = targetPosition.left - xOffset;
        }
        else if (this.isPosition(positionParts, 'right')) {
            x = targetPosition.right + xOffset;
        }
        else {
            x = (targetPosition.left + targetPosition.right) / 2;
        }
        if (this.isPosition(positionParts, 'top')) {
            y = targetPosition.top - yOffset;
        }
        else if (this.isPosition(positionParts, 'bottom')) {
            y = targetPosition.bottom + yOffset;
        }
        else {
            y = (targetPosition.top + targetPosition.bottom) / 2;
        }
        return [x, y];
    };
    PopOverComponent.prototype.computePosition = function (el, event) {
        var baseX;
        var baseY;
        var boundryMargin = 5;
        var bodyPosition = el.ownerDocument.body.getClientRects()[0];
        if (this.anchorTo) {
            var target = (this.anchorTo instanceof Node ? this.anchorTo : event.target);
            _a = this.computeAtPosition(target, this.at), baseX = _a[0], baseY = _a[1];
        }
        else {
            _b = [event.clientX, event.clientY], baseX = _b[0], baseY = _b[1];
        }
        var _c = this.computeAtPosition(el, (this.my) || '', this.xOffset, this.yOffset), offsetX = _c[0], offsetY = _c[1];
        var elPosition = el.getBoundingClientRect();
        var pagePosition = el.ownerDocument.body.getBoundingClientRect();
        var documentElement = el.ownerDocument.documentElement;
        offsetX = offsetX - elPosition.left + pagePosition.left;
        offsetY = offsetY - elPosition.top + pagePosition.top;
        return [
            Math.max(boundryMargin - bodyPosition.left, Math.min(baseX - offsetX, documentElement.clientWidth - bodyPosition.left - elPosition.width - boundryMargin)),
            Math.max(boundryMargin - bodyPosition.top, Math.min(baseY - offsetY, documentElement.clientHeight - bodyPosition.top - elPosition.height - boundryMargin))
        ];
        var _a, _b;
    };
    PopOverComponent.prototype.hide = function () {
        this.renderer.setElementStyle(this.content.nativeElement, 'opacity', '0');
        this.renderer.setElementStyle(this.content.nativeElement, 'visibility', 'hidden');
        this.visible$.next(false);
        this.originalParent && this.originalParent.appendChild(this.content.nativeElement);
    };
    PopOverComponent.prototype.show = function (event) {
        var _this = this;
        this.clickSubscription && this.clickSubscription.unsubscribe();
        this.visible$.next(true);
        var el = this.content.nativeElement;
        this.originalParent = el.parentNode;
        el.ownerDocument.body.appendChild(el);
        this.renderer.setElementStyle(this.content.nativeElement, 'visibility', 'inherit');
        Rx_1.Observable.timer(0).take(1).subscribe(function () {
            var _a = _this.computePosition(el, event), x = _a[0], y = _a[1];
            _this.renderer.setElementStyle(el, 'top', y + 'px');
            _this.renderer.setElementStyle(el, 'left', x + 'px');
            _this.renderer.setElementStyle(el, 'opacity', '1');
            if (!_this.keepOnClickOutside) {
                _this.clickSubscription = Rx_1.Observable.fromEvent(el.ownerDocument, 'click')
                    .skipUntil(Rx_1.Observable.timer(0))
                    .filter(function (md) { return !el.contains(md.target); })
                    .take(1)
                    .subscribe(function (v) { return (_this.hide()); });
            }
        });
    };
    PopOverComponent.prototype.toggle = function (event) {
        var _this = this;
        this.visible$
            .take(1)
            .subscribe(function (visible) { return (visible ? _this.hide() : _this.show(event)); });
    };
    __decorate([
        core_1.Input('show-on'), 
        __metadata('design:type', Rx_1.Observable), 
        __metadata('design:paramtypes', [Rx_1.Observable])
    ], PopOverComponent.prototype, "showOn", null);
    __decorate([
        core_1.Input('hide-on'), 
        __metadata('design:type', Rx_1.Observable), 
        __metadata('design:paramtypes', [Rx_1.Observable])
    ], PopOverComponent.prototype, "hideOn", null);
    __decorate([
        core_1.Input('keep-on-click-outside'), 
        __metadata('design:type', Boolean)
    ], PopOverComponent.prototype, "keepOnClickOutside", void 0);
    __decorate([
        core_1.Input('anchor-to'), 
        __metadata('design:type', Object)
    ], PopOverComponent.prototype, "anchorTo", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], PopOverComponent.prototype, "my", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], PopOverComponent.prototype, "at", void 0);
    __decorate([
        core_1.Input('x-offset'), 
        __metadata('design:type', Number)
    ], PopOverComponent.prototype, "xOffset", void 0);
    __decorate([
        core_1.Input('y-offset'), 
        __metadata('design:type', Number)
    ], PopOverComponent.prototype, "yOffset", void 0);
    __decorate([
        core_1.Input('content-class'), 
        __metadata('design:type', String)
    ], PopOverComponent.prototype, "contentClass", void 0);
    __decorate([
        core_1.ViewChild('popOverContent'), 
        __metadata('design:type', Object)
    ], PopOverComponent.prototype, "content", void 0);
    PopOverComponent = __decorate([
        core_1.Component({
            selector: 'pop-over',
            styles: [
                ".pop-over-content {\n            position: absolute;\n            transition: opacity 0.2s ease-in-out;\n            background: #FFFFFF;\n        }"
            ],
            template: "<div class=\"pop-over\">\n        <div #popOverContent class=\"pop-over-content\" [ngClass]=\"contentClass\"\n             [class.shown]=\"visible$ | async\">\n            <ng-content *ngIf=\"visible$ | async\"></ng-content>\n        </div>\n    </div>"
        }), 
        __metadata('design:paramtypes', [core_1.ElementRef, core_1.Renderer])
    ], PopOverComponent);
    return PopOverComponent;
}());
exports.PopOverComponent = PopOverComponent;

//# sourceMappingURL=pop-over.component.js.map
