import { AfterContentInit, AnimationTransitionEvent, EventEmitter, OnChanges, OnDestroy, SimpleChanges } from '@angular/core';
export declare const SIDEBAR_POSITION: {
    Left: string;
    Right: string;
    Top: string;
    Bottom: string;
};
export declare class Sidebar implements AfterContentInit, OnChanges, OnDestroy {
    private _document;
    open: boolean;
    openChange: EventEmitter<boolean>;
    keyClose: boolean;
    keyCode: number;
    position: string;
    closeOnClickOutside: boolean;
    showOverlay: boolean;
    animate: boolean;
    defaultStyles: boolean;
    sidebarClass: string;
    overlayClass: string;
    ariaLabel: string;
    trapFocus: boolean;
    autoFocus: boolean;
    onOpen: EventEmitter<null>;
    onClose: EventEmitter<null>;
    onAnimationStarted: EventEmitter<AnimationTransitionEvent>;
    onAnimationDone: EventEmitter<AnimationTransitionEvent>;
    private _elSidebar;
    private _closeDirectives;
    private _onClickOutsideAttached;
    private _onKeyDownAttached;
    private _focusableElementsString;
    private _focusableElements;
    private _focusedBeforeOpen;
    constructor(_document: any);
    ngAfterContentInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    ngOnDestroy(): void;
    private _setVisibleSidebarState();
    private _open();
    private _close();
    private _manualClose();
    private _setFocusToFirstItem();
    private _trapFocus(e);
    private _setFocused(open);
    private _initCloseListeners();
    private _destroyCloseListeners();
    private _onClickOutside(e);
    private _onKeyDown(e);
}
