var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('angular2/core');
var common_1 = require('angular2/common');
var ng_table_sorting_directive_1 = require('./ng-table-sorting.directive');
var NgTable = (function () {
    function NgTable() {
        this.rows = [];
        this._columns = [];
        this.config = {};
        this.tableChanged = new core_1.EventEmitter();
    }
    Object.defineProperty(NgTable.prototype, "columns", {
        get: function () {
            return this._columns;
        },
        set: function (values) {
            var _this = this;
            values.forEach(function (value) {
                var column = _this._columns.find(function (col) { return col.name === value.name; });
                if (column) {
                    Object.assign(column, value);
                }
                if (!column) {
                    _this._columns.push(value);
                }
            });
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(NgTable.prototype, "configColumns", {
        get: function () {
            var sortColumns = [];
            this.columns.forEach(function (column) {
                if (column.sort) {
                    sortColumns.push(column);
                }
            });
            return { columns: sortColumns };
        },
        enumerable: true,
        configurable: true
    });
    NgTable.prototype.onChangeTable = function (column) {
        this.columns = [column];
        this.tableChanged.emit({ sorting: this.configColumns });
    };
    NgTable = __decorate([
        core_1.Component({
            selector: 'ngTable, [ngTable]',
            inputs: ['rows', 'columns', 'config'],
            outputs: ['tableChanged'],
            template: "\n    <table class=\"table table-striped table-bordered dataTable\"\n           role=\"grid\" style=\"width: 100%;\">\n      <thead>\n      <tr role=\"row\">\n        <th *ngFor=\"#column of columns\" [ngTableSorting]=\"config\" [column]=\"column\" (sortChanged)=\"onChangeTable($event)\">\n          {{column.title}}\n          <i *ngIf=\"config && column.sort\" class=\"pull-right glyphicon\"\n            [ngClass]=\"{'glyphicon-chevron-down': column.sort === 'desc', 'glyphicon-chevron-up': column.sort === 'asc'}\"></i>\n        </th>\n      </tr>\n      </thead>\n      <tbody>\n      <tr *ngFor=\"#row of rows\">\n        <td *ngFor=\"#column of columns\">{{row[column.name]}}</td>\n      </tr>\n      </tbody>\n    </table>\n",
            directives: [ng_table_sorting_directive_1.NgTableSorting, common_1.NgClass, common_1.CORE_DIRECTIVES, common_1.FORM_DIRECTIVES]
        }), 
        __metadata('design:paramtypes', [])
    ], NgTable);
    return NgTable;
})();
exports.NgTable = NgTable;
//# sourceMappingURL=ng-table.component.js.map