System.registerDynamic("ng2-toastr/src/toast-container.component",["@angular/core","./toast-options","@angular/platform-browser"],!0,function($__require,exports,module){"use strict";var global=this,__define=global.define;global.define=void 0;var core_1=$__require("@angular/core"),toast_options_1=$__require("./toast-options"),platform_browser_1=$__require("@angular/platform-browser"),ToastContainer=function(){function ToastContainer(sanitizer,options){this.sanitizer=sanitizer,this.position="fixed",this.messageClass="toast-message",this.titleClass="toast-title",this.positionClass="toast-top-right",this.toasts=[],this.maxShown=5,this.animate="fade",options&&Object.assign(this,options)}return ToastContainer.prototype.addToast=function(toast){this.positionClass.indexOf("top")>0?(this.toasts.push(toast),this.toasts.length>this.maxShown&&this.toasts.splice(0,this.toasts.length-this.maxShown)):(this.toasts.unshift(toast),this.toasts.length>this.maxShown&&this.toasts.splice(this.maxShown,this.toasts.length-this.maxShown))},ToastContainer.prototype.removeToast=function(toastId){this.toasts=this.toasts.filter(function(toast){return toast.id!==toastId})},ToastContainer.prototype.removeAllToasts=function(){this.toasts=[]},ToastContainer.prototype.clicked=function(toast){this.onToastClicked&&this.onToastClicked(toast)},ToastContainer.prototype.anyToast=function(){return this.toasts.length>0},ToastContainer.prototype.findToast=function(toastId){for(var _i=0,_a=this.toasts;_i<_a.length;_i++){var toast=_a[_i];if(toast.id===toastId)return toast}return null},ToastContainer.decorators=[{type:core_1.Component,args:[{selector:"toast-container",template:'\n    <div id="toast-container" [style.position]="position" class="{{positionClass}}">\n      <div *ngFor="let toast of toasts" [@inOut]="animate" class="toast toast-{{toast.type}}" (click)="clicked(toast)">\n        <div *ngIf="toast.title" class="{{toast.titleClass || titleClass}}">{{toast.title}}</div>\n        <div [ngSwitch]="toast.enableHTML">\n          <span *ngSwitchCase="true" [innerHTML]="sanitizer.bypassSecurityTrustHtml(toast.message)"></span>\n          <span *ngSwitchDefault class="{{toast.messageClass || messageClass}}">{{toast.message}}</span>\n        </div>              \n      </div>\n    </div>\n    ',animations:[core_1.trigger("inOut",[core_1.state("flyRight, flyLeft",core_1.style({opacity:1,transform:"translateX(0)"})),core_1.state("fade",core_1.style({opacity:1})),core_1.state("slideDown, slideUp",core_1.style({opacity:1,transform:"translateY(0)"})),core_1.transition("void => flyRight",[core_1.style({opacity:0,transform:"translateX(100%)"}),core_1.animate("0.2s ease-in")]),core_1.transition("flyRight => void",[core_1.animate("0.2s 10 ease-out",core_1.style({opacity:0,transform:"translateX(100%)"}))]),core_1.transition("void => flyLeft",[core_1.style({opacity:0,transform:"translateX(-100%)"}),core_1.animate("0.2s ease-in")]),core_1.transition("flyLeft => void",[core_1.animate("0.2s 10 ease-out",core_1.style({opacity:0,transform:"translateX(-100%)"}))]),core_1.transition("void => fade",[core_1.style({opacity:0}),core_1.animate("0.3s ease-in")]),core_1.transition("fade => void",[core_1.animate("0.3s 10 ease-out",core_1.style({opacity:0}))]),core_1.transition("void => slideDown",[core_1.style({opacity:0,transform:"translateY(-200%)"}),core_1.animate("0.3s ease-in")]),core_1.transition("slideDown => void",[core_1.animate("0.3s 10 ease-out",core_1.style({opacity:0,transform:"translateY(-200%)"}))]),core_1.transition("void => slideUp",[core_1.style({opacity:0,transform:"translateY(200%)"}),core_1.animate("0.3s ease-in")]),core_1.transition("slideUp => void",[core_1.animate("0.3s 10 ease-out",core_1.style({opacity:0,transform:"translateY(200%)"}))])])]}]}],ToastContainer.ctorParameters=[{type:platform_browser_1.DomSanitizer},{type:toast_options_1.ToastOptions,decorators:[{type:core_1.Optional}]}],ToastContainer}();return exports.ToastContainer=ToastContainer,global.define=__define,module.exports}),System.registerDynamic("ng2-toastr/src/toast",[],!0,function($__require,exports,module){"use strict";var global=this,__define=global.define;global.define=void 0;var Toast=function(){function Toast(type,message,title){this.type=type,this.message=message,this.title=title,this.enableHTML=!1}return Toast}();return exports.Toast=Toast,global.define=__define,module.exports}),System.registerDynamic("ng2-toastr/src/toast-manager",["@angular/core","./toast-container.component","./toast-options","./toast"],!0,function($__require,exports,module){"use strict";var global=this,__define=global.define;global.define=void 0;var core_1=$__require("@angular/core"),toast_container_component_1=$__require("./toast-container.component"),toast_options_1=$__require("./toast-options"),toast_1=$__require("./toast"),ToastsManager=function(){function ToastsManager(componentFactoryResolver,appRef,options){this.componentFactoryResolver=componentFactoryResolver,this.appRef=appRef,this.options={dismiss:"auto",toastLife:3e3},this.index=0,options&&Object.assign(this.options,options)}return ToastsManager.prototype.show=function(toast,options){var _this=this;return new Promise(function(resolve,reject){if(!_this.container){if(!_this.appRef._rootComponents.length){var err=new Error("Application root component cannot be found. Try accessing application reference in the later life cycle of angular app.");console.error(err),reject(err)}var appContainer=_this.appRef._rootComponents[0]._hostElement.vcRef,providers=core_1.ReflectiveInjector.resolve([{provide:toast_options_1.ToastOptions,useValue:_this.options}]),toastFactory=_this.componentFactoryResolver.resolveComponentFactory(toast_container_component_1.ToastContainer),childInjector=core_1.ReflectiveInjector.fromResolvedProviders(providers,appContainer.parentInjector);_this.container=appContainer.createComponent(toastFactory,appContainer.length,childInjector),_this.container.instance.onToastClicked=function(toast){_this.onToastClicked(toast)}}resolve(_this.setupToast(toast,options))})},ToastsManager.prototype.createTimeout=function(toastId,timeout){var _this=this,life=timeout||this.options.toastLife;setTimeout(function(){_this.clearToast(toastId)},life)},ToastsManager.prototype.setupToast=function(toast,options){return toast.id=++this.index,options&&"string"==typeof options.messageClass&&(toast.messageClass=options.messageClass),options&&"string"==typeof options.titleClass&&(toast.titleClass=options.titleClass),options&&"boolean"==typeof options.enableHTML&&(toast.enableHTML=options.enableHTML),options&&"string"==typeof options.dismiss?toast.dismiss=options.dismiss:options&&"boolean"==typeof options.autoDismiss?toast.dismiss=options.autoDismiss?"auto":"click":toast.dismiss=this.options.dismiss,options&&"number"==typeof options.toastLife?(toast.dismiss="auto",this.createTimeout(toast.id,options.toastLife)):"auto"===toast.dismiss&&this.createTimeout(toast.id),this.container.instance.addToast(toast),toast},ToastsManager.prototype.onToastClicked=function(toast){"click"===toast.dismiss&&this.clearToast(toast.id)},ToastsManager.prototype.dismissToast=function(toast){this.clearToast(toast.id)},ToastsManager.prototype.clearToast=function(toastId){if(this.container){var instance=this.container.instance;instance.removeToast(toastId),instance.anyToast()||this.dispose()}},ToastsManager.prototype.clearAllToasts=function(){if(this.container){var instance=this.container.instance;instance.removeAllToasts(),this.dispose()}},ToastsManager.prototype.dispose=function(){var _this=this;setTimeout(function(){_this.container&&!_this.container.instance.anyToast()&&(_this.container.destroy(),_this.container=null)},2e3)},ToastsManager.prototype.error=function(message,title,options){var toast=new toast_1.Toast("error",message,title);return this.show(toast,options)},ToastsManager.prototype.info=function(message,title,options){var toast=new toast_1.Toast("info",message,title);return this.show(toast,options)},ToastsManager.prototype.success=function(message,title,options){var toast=new toast_1.Toast("success",message,title);return this.show(toast,options)},ToastsManager.prototype.warning=function(message,title,options){var toast=new toast_1.Toast("warning",message,title);return this.show(toast,options)},ToastsManager.prototype.custom=function(message,title,options){var toast=new toast_1.Toast("custom",message,title);return this.show(toast,options)},ToastsManager.decorators=[{type:core_1.Injectable}],ToastsManager.ctorParameters=[{type:core_1.ComponentFactoryResolver},{type:core_1.ApplicationRef},{type:toast_options_1.ToastOptions,decorators:[{type:core_1.Optional}]}],ToastsManager}();return exports.ToastsManager=ToastsManager,global.define=__define,module.exports}),System.registerDynamic("ng2-toastr/src/toast-options",["@angular/core"],!0,function($__require,exports,module){"use strict";var global=this,__define=global.define;global.define=void 0;var core_1=$__require("@angular/core"),ToastOptions=function(){function ToastOptions(options){this.enableHTML=!1,this.animate="fade",Object.assign(this,options)}return ToastOptions.decorators=[{type:core_1.Injectable}],ToastOptions.ctorParameters=[{type:Object}],ToastOptions}();return exports.ToastOptions=ToastOptions,global.define=__define,module.exports}),System.registerDynamic("ng2-toastr/src/toast.module",["@angular/core","@angular/common","./toast-container.component","./toast-manager","./toast-options"],!0,function($__require,exports,module){"use strict";var global=this,__define=global.define;global.define=void 0;var core_1=$__require("@angular/core"),common_1=$__require("@angular/common"),toast_container_component_1=$__require("./toast-container.component"),toast_manager_1=$__require("./toast-manager"),toast_options_1=$__require("./toast-options"),ToastModule=function(){function ToastModule(){}return ToastModule.forRoot=function(config){return{ngModule:ToastModule,providers:[{provide:toast_options_1.ToastOptions,useValue:config}]}},ToastModule.decorators=[{type:core_1.NgModule,args:[{imports:[common_1.CommonModule],declarations:[toast_container_component_1.ToastContainer],exports:[toast_container_component_1.ToastContainer],providers:[toast_manager_1.ToastsManager],entryComponents:[toast_container_component_1.ToastContainer]}]}],ToastModule.ctorParameters=[],ToastModule}();return exports.ToastModule=ToastModule,global.define=__define,module.exports}),System.registerDynamic("ng2-toastr/ng2-toastr",["./src/toast","./src/toast-manager","./src/toast-container.component","./src/toast-options","./src/toast.module"],!0,function($__require,exports,module){"use strict";function __export(m){for(var p in m)exports.hasOwnProperty(p)||(exports[p]=m[p])}var global=this,__define=global.define;return global.define=void 0,__export($__require("./src/toast")),__export($__require("./src/toast-manager")),__export($__require("./src/toast-container.component")),__export($__require("./src/toast-options")),__export($__require("./src/toast.module")),global.define=__define,module.exports});
//# sourceMappingURL=ng2-toastr.min.js.map