import { OnInit, ElementRef } from '@angular/core';
import * as TreeTypes from './tree.types';
import { Tree } from './tree';
import { NodeMenuService } from './menu/node-menu.service';
import { NodeMenuItemSelectedEvent } from './menu/menu.events';
import { NodeEditableEvent } from './editable/editable.events';
import { TreeService } from './tree.service';
export declare class TreeInternalComponent implements OnInit {
    private nodeMenuService;
    treeService: TreeService;
    element: ElementRef;
    tree: Tree;
    settings: TreeTypes.Ng2TreeSettings;
    isSelected: boolean;
    isRightMenuVisible: boolean;
    isLeftMenuVisible: boolean;
    constructor(nodeMenuService: NodeMenuService, treeService: TreeService, element: ElementRef);
    ngOnInit(): void;
    private swapWithSibling(sibling, tree);
    private moveNodeToThisTreeAndRemoveFromPreviousOne(e, tree);
    private moveNodeToParentTreeAndRemoveFromPreviousOne(e, tree);
    onNodeSelected(e: MouseEvent): void;
    showRightMenu(e: MouseEvent): void;
    showLeftMenu(e: MouseEvent): void;
    onMenuItemSelected(e: NodeMenuItemSelectedEvent): void;
    private onNewSelected(e);
    private onRenameSelected();
    private onRemoveSelected();
    onSwitchFoldingType(): void;
    applyNewValue(e: NodeEditableEvent): void;
    shouldShowInputForTreeValue(): boolean;
    isRootHidden(): boolean;
}
