import { EventEmitter } from '@angular/core';
export declare class UploadedFile {
    id: string;
    status: number;
    statusText: string;
    progress: Object;
    originalName: string;
    size: number;
    response: string;
    done: boolean;
    error: boolean;
    abort: boolean;
    startTime: number;
    endTime: number;
    speedAverage: number;
    speedAverageHumanized: string;
    constructor(id: string, originalName: string, size: number);
    setProgres(progress: Object): void;
    setError(): void;
    setAbort(): void;
    onFinished(status: number, statusText: string, response: string): void;
}
export declare class Ng2Uploader {
    url: string;
    cors: boolean;
    withCredentials: boolean;
    multiple: boolean;
    maxUploads: number;
    data: {
        [index: string]: any;
    };
    autoUpload: boolean;
    multipart: boolean;
    method: string;
    debug: boolean;
    customHeaders: any;
    encodeHeaders: boolean;
    authTokenPrefix: string;
    authToken: string;
    fieldName: string;
    fieldReset: boolean;
    previewUrl: boolean;
    calculateSpeed: boolean;
    _queue: any[];
    _emitter: EventEmitter<any>;
    _previewEmitter: EventEmitter<any>;
    _beforeEmitter: EventEmitter<any>;
    setOptions(options: any): void;
    uploadFilesInQueue(): void;
    uploadFile(file: any): void;
    addFilesToQueue(files: File[]): void;
    createFileUrl(file: File): void;
    removeFileFromQueue(i: number): void;
    clearQueue(): void;
    getQueueSize(): number;
    inQueue(file: any): boolean;
    isFile(file: any): boolean;
    generateRandomIndex(): string;
}
export declare class UploadRejected {
    static readonly EXTENSION_NOT_ALLOWED: string;
    static readonly MAX_SIZE_EXCEEDED: string;
    file: any;
    reason: string;
}
