"use strict";
/**
 * attributeTableReader module.
 * @module attributes/attributeTableReader
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var userTableReader_1 = require("../user/userTableReader");
var attributeTable_1 = require("./attributeTable");
/**
 * Reads the metadata from an existing attribute table
 * @class AttributeTableReader
 * @extends UserTableReader
 * @classdesc Reads the metadata from an existing attributes table
 */
var AttributeTableReader = /** @class */ (function (_super) {
    __extends(AttributeTableReader, _super);
    function AttributeTableReader() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * @inheritdoc
     */
    AttributeTableReader.prototype.createTable = function (tableName, columns) {
        return new attributeTable_1.AttributeTable(tableName, columns);
    };
    return AttributeTableReader;
}(userTableReader_1.UserTableReader));
exports.AttributeTableReader = AttributeTableReader;
//# sourceMappingURL=attributeTableReader.js.map