"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
/* eslint-disable camelcase */
/**
 * SpatialReferenceSystem module.
 * @module core/srs
 */
var proj4_1 = __importDefault(require("proj4"));
/**
 * Spatial Reference System object. The coordinate reference system definitions it contains are referenced by the GeoPackage Contents and GeometryColumns objects to relate the vector and tile data in user tables to locations on the earth.
 * @class SpatialReferenceSystem
 */
var SpatialReferenceSystem = /** @class */ (function () {
    function SpatialReferenceSystem() {
    }
    Object.defineProperty(SpatialReferenceSystem.prototype, "projection", {
        /**
         * Return the proj4 projection specified by this SpatialReferenceSystem
         * @return {*}
         */
        get: function () {
            if (this.organization === 'NONE')
                return null;
            if (this.organization_coordsys_id === 4326 && (this.organization === 'EPSG' || this.organization === 'epsg')) {
                return proj4_1.default('EPSG:4326');
            }
            else if (this.definition_12_063 && this.definition_12_063 !== '' && this.definition_12_063 !== 'undefined') {
                return proj4_1.default(this.definition_12_063);
            }
            else if (this.definition && this.definition !== '' && this.definition !== 'undefined') {
                return proj4_1.default(this.definition);
            }
            else if (this.organization && this.organization_coordsys_id) {
                return proj4_1.default(this.organization.toUpperCase() + ':' + this.organization_coordsys_id);
            }
            return null;
        },
        enumerable: true,
        configurable: true
    });
    SpatialReferenceSystem.TABLE_NAME = 'gpkg_spatial_ref_sys';
    return SpatialReferenceSystem;
}());
exports.SpatialReferenceSystem = SpatialReferenceSystem;
//# sourceMappingURL=spatialReferenceSystem.js.map