/// <reference types="proj4" />
import { Dao } from '../../dao/dao';
import { SpatialReferenceSystem } from './spatialReferenceSystem';
import { DBValue } from '../../db/dbAdapter';
/**
 * Spatial Reference System Data Access Object
 * @extends Dao
 * @class SpatialReferenceSystemDao
 * @param {module:geoPackage~GeoPackage} geoPackage The GeoPackage object
 */
export declare class SpatialReferenceSystemDao extends Dao<SpatialReferenceSystem> {
    /**
     * Spatial Reference System Table Name
     * @type {String}
     */
    static readonly TABLE_NAME: string;
    /**
     * srsName field name
     * @type {String}
     */
    static readonly COLUMN_SRS_NAME: string;
    /**
     * srsId field name
     * @type {String}
     */
    static readonly COLUMN_SRS_ID: string;
    /**
     * id field name, srsId
     * @type {String}
     */
    static readonly COLUMN_ID: string;
    /**
     * organization field name
     * @type {String}
     */
    static readonly COLUMN_ORGANIZATION: string;
    /**
     * organizationCoordsysId field name
     * @type {String}
     */
    static readonly COLUMN_ORGANIZATION_COORDSYS_ID: string;
    /**
     * definition field name
     * @type {String}
     */
    static readonly COLUMN_DEFINITION: string;
    /**
     * description field name
     * @type {String}
     */
    static readonly COLUMN_DESCRIPTION: string;
    readonly idColumns: string[];
    /**
     * Table Name
     * @type {String}
     */
    readonly gpkgTableName: string;
    /**
     * Create a new SpatialReferenceSystem object
     * @return {module:core/srs~SpatialReferenceSystem}
     */
    createObject(results?: Record<string, DBValue>): SpatialReferenceSystem;
    /**
     * Get the Spatial Reference System for the provided id
     * @param  {Number}   srsId srs id
     * @return {module:core/srs~SpatialReferenceSystem}
     */
    getBySrsId(srsId: number): SpatialReferenceSystem;
    /**
     * Return the proj4 projection specified by this SpatialReferenceSystem
     * @return {typeof proj4}
     */
    getProjection(srs: SpatialReferenceSystem): proj4.Converter;
    /**
     * Creates the required EPSG WGS84 Spatial Reference System (spec
     * Requirement 11)
     * @return {Number} id of the created row
     */
    createWgs84(): number;
    /**
     * Creates the required Undefined Cartesian Spatial Reference System (spec
     * Requirement 11)
     * @return {Number} id of the created row
     */
    createUndefinedCartesian(): number;
    /**
     * Creates the required Undefined Geographic Spatial Reference System (spec
     * Requirement 11)
     * @return {Number} id of the created row
     */
    createUndefinedGeographic(): number;
    /**
     * Creates the Web Mercator Spatial Reference System if it does not already
     * exist
     * @return {Number} id of the created row
     */
    createWebMercator(): number;
}
