import { Dao } from '../dao/dao';
import { DataColumnConstraints } from './dataColumnConstraints';
import { DBValue } from '../db/dbAdapter';
/**
 * DataColumnConstraints module.
 * @module dataColumnConstraints
 */
/**
 * Data Column Constraints Data Access Object
 * @class
 * @extends Dao
 * @param  {module:geoPackage~GeoPackage} geoPackage GeoPackage object
 */
export declare class DataColumnConstraintsDao extends Dao<DataColumnConstraints> {
    static readonly TABLE_NAME: string;
    static readonly COLUMN_CONSTRAINT_NAME: string;
    static readonly COLUMN_CONSTRAINT_TYPE: string;
    static readonly COLUMN_VALUE: string;
    static readonly COLUMN_MIN: string;
    static readonly COLUMN_MIN_IS_INCLUSIVE: string;
    static readonly COLUMN_MAX: string;
    static readonly COLUMN_MAX_IS_INCLUSIVE: string;
    static readonly COLUMN_DESCRIPTION: string;
    static readonly ENUM_TYPE: string;
    static readonly GLOB_TYPE: string;
    static readonly RANGE_TYPE: string;
    readonly gpkgTableName: string;
    readonly idColumns: string[];
    /**
     * Creates a new DataColumnConstraints object
     * @return {module:dataColumnConstraints~DataColumnConstraints}
     */
    createObject(results?: Record<string, DBValue>): DataColumnConstraints;
    /**
     * query by constraint name
     * @param  {String} constraintName     constraint name
     * @return {Iterable}
     */
    queryByConstraintName(constraintName: string): IterableIterator<DataColumnConstraints>;
    /**
     * Query by the unique column values
     * @param  {String} constraintName     constraint name
     * @param  {String} constraintType     constraint type
     * @param  {String} value              value
     * @return {module:dataColumnConstraints~DataColumnConstraints}
     */
    queryUnique(constraintName: string, constraintType: string, value: string): DataColumnConstraints;
}
