import { Dao } from '../dao/dao';
import { DataColumns } from './dataColumns';
import { Contents } from '../core/contents/contents';
import { DBValue } from '../db/dbAdapter';
/**
 * DataColumns module.
 * @module dataColumns
 */
/**
 * Contents object. Provides identifying and descriptive information that an
 * application can display to a user in a menu of geospatial data that is
 * available for access and/or update.
 * @class
 * @extends Dao
 * @param  {module:geoPackage~GeoPackage} geoPackage GeoPackage object
 */
export declare class DataColumnsDao extends Dao<DataColumns> {
    static readonly TABLE_NAME: string;
    static readonly COLUMN_PK1: string;
    static readonly COLUMN_PK2: string;
    static readonly COLUMN_TABLE_NAME: string;
    static readonly COLUMN_COLUMN_NAME: string;
    static readonly COLUMN_NAME: string;
    static readonly COLUMN_TITLE: string;
    static readonly COLUMN_DESCRIPTION: string;
    static readonly COLUMN_MIME_TYPE: string;
    static readonly COLUMN_CONSTRAINT_NAME: string;
    readonly gpkgTableName: string;
    readonly idColumns: string[];
    /**
     * Creates a new {module:dataColumns~DataColumns} object
     * @return {module:dataColumns~DataColumns}
     */
    createObject(results?: Record<string, DBValue>): DataColumns;
    /**
     * Get the Contents from the Data Columns
     * @param  {module:dataColumns~DataColumns} dataColumns data columns
     * @return {module:core/contents~Contents}             contents
     */
    getContents(dataColumns: DataColumns): Contents;
    /**
     * Query by constraint name
     * @param  {String} constraintName     constraint name
     * @return {Iterable.<Object>} iterator of database objects
     */
    queryByConstraintName(constraintName: string): IterableIterator<DataColumns>;
    /**
     * Get DataColumn by column name and table name
     * @param  {String} tableName  table name
     * @param  {String} columnName column name
     * @return {module:dataColumns~DataColumns}
     */
    getDataColumns(tableName: string, columnName: string): DataColumns;
}
