"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var dao_1 = require("../dao/dao");
var contentsDao_1 = require("../core/contents/contentsDao");
var dataColumns_1 = require("./dataColumns");
/**
 * DataColumns module.
 * @module dataColumns
 */
/**
 * Contents object. Provides identifying and descriptive information that an
 * application can display to a user in a menu of geospatial data that is
 * available for access and/or update.
 * @class
 * @extends Dao
 * @param  {module:geoPackage~GeoPackage} geoPackage GeoPackage object
 */
var DataColumnsDao = /** @class */ (function (_super) {
    __extends(DataColumnsDao, _super);
    function DataColumnsDao() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.gpkgTableName = DataColumnsDao.TABLE_NAME;
        _this.idColumns = [DataColumnsDao.COLUMN_PK1, DataColumnsDao.COLUMN_PK2];
        return _this;
    }
    /**
     * Creates a new {module:dataColumns~DataColumns} object
     * @return {module:dataColumns~DataColumns}
     */
    DataColumnsDao.prototype.createObject = function (results) {
        var dc = new dataColumns_1.DataColumns();
        if (results) {
            dc.table_name = results.table_name;
            dc.column_name = results.column_name;
            dc.name = results.name;
            dc.title = results.title;
            dc.description = results.description;
            dc.mime_type = results.mime_type;
            dc.constraint_name = results.constraint_name;
        }
        return dc;
    };
    /**
     * Get the Contents from the Data Columns
     * @param  {module:dataColumns~DataColumns} dataColumns data columns
     * @return {module:core/contents~Contents}             contents
     */
    DataColumnsDao.prototype.getContents = function (dataColumns) {
        var cd = new contentsDao_1.ContentsDao(this.geoPackage);
        return cd.queryForId(dataColumns.table_name);
    };
    /**
     * Query by constraint name
     * @param  {String} constraintName     constraint name
     * @return {Iterable.<Object>} iterator of database objects
     */
    DataColumnsDao.prototype.queryByConstraintName = function (constraintName) {
        return this.queryForEach(DataColumnsDao.COLUMN_CONSTRAINT_NAME, constraintName);
    };
    /**
     * Get DataColumn by column name and table name
     * @param  {String} tableName  table name
     * @param  {String} columnName column name
     * @return {module:dataColumns~DataColumns}
     */
    DataColumnsDao.prototype.getDataColumns = function (tableName, columnName) {
        var e_1, _a;
        var exists = this.isTableExists();
        if (!exists) {
            return;
        }
        var where = this.buildWhereWithFieldAndValue(DataColumnsDao.COLUMN_TABLE_NAME, tableName) +
            ' and ' +
            this.buildWhereWithFieldAndValue(DataColumnsDao.COLUMN_COLUMN_NAME, columnName);
        var values = [tableName, columnName];
        var dataColumn;
        try {
            for (var _b = __values(this.queryWhere(where, values)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var row = _c.value;
                dataColumn = row;
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return dataColumn;
    };
    DataColumnsDao.TABLE_NAME = 'gpkg_data_columns';
    DataColumnsDao.COLUMN_PK1 = 'table_name';
    DataColumnsDao.COLUMN_PK2 = 'column_name';
    DataColumnsDao.COLUMN_TABLE_NAME = 'table_name';
    DataColumnsDao.COLUMN_COLUMN_NAME = 'column_name';
    DataColumnsDao.COLUMN_NAME = 'name';
    DataColumnsDao.COLUMN_TITLE = 'title';
    DataColumnsDao.COLUMN_DESCRIPTION = 'description';
    DataColumnsDao.COLUMN_MIME_TYPE = 'mime_type';
    DataColumnsDao.COLUMN_CONSTRAINT_NAME = 'constraint_name';
    return DataColumnsDao;
}(dao_1.Dao));
exports.DataColumnsDao = DataColumnsDao;
//# sourceMappingURL=dataColumnsDao.js.map