"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
var geoPackageConstants_1 = require("../geoPackageConstants");
/**
 * Connection to the SQLite file
 * @module db/geoPackageConnection
 */
if (typeof process !== 'undefined' && process.version && !process.env.FORCE_SQLJS) {
    console.log('Better SQLite');
}
else {
    console.log('SQL.js');
}
/**
 * Represents a connection to the GeoPackage database
 */
var GeoPackageConnection = /** @class */ (function () {
    /**
     * Construct a new connection to the GeoPackage SQLite file
     * @param filePath path to the sqlite file
     */
    function GeoPackageConnection(filePath) {
        this.filePath = filePath;
    }
    /**
     * Creates a connection to the SQLite file and when connected, returns a promise that resolves the connection.
     * This will create a {module:db/sqliteAdapter~Adapter} if running in node and the FORCE_SQLJS environment variable is not set.
     * This will create a {module:db/sqljsAdapter~Adapter} if running in the browser or the FORCE_SQLJS environment variable is set
     * @return {Promise<GeoPackageConnection>}
     */
    GeoPackageConnection.prototype.init = function () {
        return __awaiter(this, void 0, void 0, function () {
            var SqliteAdapter_1, SqljsAdapter_1, e_1;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 6, , 7]);
                        if (!(typeof process !== 'undefined' && process.version && !process.env.FORCE_SQLJS)) return [3 /*break*/, 2];
                        return [4 /*yield*/, Promise.resolve().then(function () { return __importStar(require('./sqliteAdapter')); })];
                    case 1:
                        SqliteAdapter_1 = (_a.sent()).SqliteAdapter;
                        this.adapterCreator = SqliteAdapter_1;
                        this.adapter = new SqliteAdapter_1(this.filePath);
                        return [3 /*break*/, 4];
                    case 2: return [4 /*yield*/, Promise.resolve().then(function () { return __importStar(require('./sqljsAdapter')); })];
                    case 3:
                        SqljsAdapter_1 = (_a.sent()).SqljsAdapter;
                        this.adapterCreator = SqljsAdapter_1;
                        this.adapter = new SqljsAdapter_1(this.filePath);
                        _a.label = 4;
                    case 4: return [4 /*yield*/, this.adapter.initialize()];
                    case 5:
                        _a.sent();
                        return [3 /*break*/, 7];
                    case 6:
                        e_1 = _a.sent();
                        console.log('Failed to create adapter', e_1);
                        throw e_1;
                    case 7: return [2 /*return*/, this];
                }
            });
        });
    };
    /**
     * Close the database.
     */
    GeoPackageConnection.prototype.close = function () {
        this.adapter.close();
    };
    /**
     * exports the GeoPackage as a file
     * @param  {Function} callback called with an err and the buffer containing the contents of the file
     */
    GeoPackageConnection.prototype.export = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.adapter.export()];
            });
        });
    };
    /**
     * Gets the raw connection to the database
     * @return {any}
     */
    GeoPackageConnection.prototype.getDBConnection = function () {
        return this.adapter.db;
    };
    /**
     * Connects to a GeoPackage database
     * @param  {any} db database to connect to
     */
    GeoPackageConnection.prototype.setDBConnection = function (db) {
        this.adapter = new this.adapterCreator();
        this.adapter.db = db;
    };
    /**
     * Registers the given function so that it can be used by SQL statements
     * @param  {string} name               name of function to register
     * @param  {Function} functionDefinition function to register
     * @return {DBAdapter} the adapter in use
     */
    GeoPackageConnection.prototype.registerFunction = function (name, functionDefinition) {
        this.adapter.registerFunction(name, functionDefinition);
        return this.adapter;
    };
    /**
     * Gets the first result from the query
     * @param  {string} sql    sql query to run
     * @param  {Array|Object} [params] array of substitution parameters
     * @return {any}
     */
    GeoPackageConnection.prototype.get = function (sql, params) {
        return this.adapter.get(sql, params);
    };
    /**
     * Checks if table exists in database
     * @param {string} tableName
     * @returns {Boolean}
     */
    GeoPackageConnection.prototype.isTableExists = function (tableName) {
        return this.adapter.isTableExists(tableName);
    };
    /**
     * Run the given SQL and return the results.
     * @param  {string} sql    sql to run
     * @param  {Array|Object} [params] array of substitution parameters
     * @return {{changes: number, lastInsertRowid: number}} object: `{ "changes": number, "lastInsertROWID": number }`
     * * `changes`: number of rows the statement changed
     * * `lastInsertROWID`: ID of the last inserted row
     */
    GeoPackageConnection.prototype.run = function (sql, params) {
        return this.adapter.run(sql, params);
    };
    /**
     * Executes the query and returns all results in an array
     * @param  {string} sql sql to run
     * @param  {Array|Object} [params] substitution parameters
     * @return {any[]}
     */
    GeoPackageConnection.prototype.all = function (sql, params) {
        return this.adapter.all(sql, params);
    };
    /**
     * Executes the query and returns an Iterable object of results
     * @param  {string} sql    sql to run
     * @param  {Array|Object} [params] substitution parameters
     * @return {IterableIterator<Object>}
     */
    GeoPackageConnection.prototype.each = function (sql, params) {
        return this.adapter.each(sql, params);
    };
    /**
     * Gets the minimum value from the column
     * @param  {string} table     table to query
     * @param  {string} column    column to get the min value from
     * @param  {string} [where]     where clause
     * @param  {Array|Object} [whereArgs] substitution parameters
     * @return {number}
     */
    GeoPackageConnection.prototype.minOfColumn = function (table, column, where, whereArgs) {
        var minStatement = 'select min(' + column + ') as min from ' + table;
        if (where) {
            minStatement += ' ';
            if (where.indexOf('where')) {
                where = 'where ' + where;
            }
            minStatement += where;
        }
        return this.adapter.get(minStatement, whereArgs).min;
    };
    /**
     * Gets the maximum value from the column
     * @param  {string} table     table to query
     * @param  {string} column    column to get the max value from
     * @param  {string} [where]     where clause
     * @param  {Array|Object} [whereArgs] substitution parameters
     * @return {number}
     */
    GeoPackageConnection.prototype.maxOfColumn = function (table, column, where, whereArgs) {
        var maxStatement = 'select max(' + column + ') as max from ' + table;
        if (where) {
            maxStatement += ' ';
            if (where.indexOf('where')) {
                where = 'where ' + where;
            }
            maxStatement += where;
        }
        return this.adapter.get(maxStatement, whereArgs).max;
    };
    /**
     * Return the count of objects in the table
     * @param  {string} table table name
     * @param  {string} [where] where clause
     * @param  {Array|Object} [whereArgs] substitution parameters
     * @return {number}
     */
    GeoPackageConnection.prototype.count = function (table, where, whereArgs) {
        return this.adapter.count(table, where, whereArgs);
    };
    /**
     * Executes an insert statement and returns the last id inserted
     * @param  {string} sql    sql to insert
     * @param  {Array|Object} params substitution parameters
     * @return {Object} last row id inserted
     */
    GeoPackageConnection.prototype.insert = function (sql, params) {
        return this.adapter.insert(sql, params);
    };
    /**
     * Delete from the table
     * @param  {string} tableName table name to delete from
     * @param  {string} [where]     where clause
     * @param  {Array|Object} [whereArgs] substitution parameters
     * @return {number} number of rows deleted
     */
    GeoPackageConnection.prototype.delete = function (tableName, where, whereArgs) {
        var deleteStatement = 'DELETE FROM ' + tableName + '';
        if (where) {
            deleteStatement += ' WHERE ' + where;
        }
        return this.adapter.delete(deleteStatement, whereArgs);
    };
    /**
     * Drops the table specified
     * @param  {string} tableName table to drop
     * @return {Boolean} results of table drop
     */
    GeoPackageConnection.prototype.dropTable = function (tableName) {
        return this.adapter.dropTable(tableName);
    };
    /**
     * Gets information about the table specified.  If data is returned, the table exists
     * @param  {string} tableName table to check
     * @return {Object}
     */
    GeoPackageConnection.prototype.tableExists = function (tableName) {
        return this.adapter.isTableExists(tableName);
    };
    /**
     * Checks if a table and column exist
     * @param  {string} tableName  table to check
     * @param  {string} columnName column to check
     * @return {Boolean}
     */
    GeoPackageConnection.prototype.columnAndTableExists = function (tableName, columnName) {
        var columns = this.adapter.all("PRAGMA table_info('" + tableName + "')");
        for (var i = 0; i < columns.length; i++) {
            if (columns[i].name === columnName) {
                return true;
            }
        }
        return false;
    };
    /**
     * Sets the APPLICATION_ID and user_version for GeoPackage
     */
    GeoPackageConnection.prototype.setApplicationId = function () {
        var buff = Buffer.from(geoPackageConstants_1.GeoPackageConstants.APPLICATION_ID);
        var applicationId = buff.readUInt32BE(0);
        this.adapter.run('PRAGMA application_id = ' + applicationId);
        this.adapter.run('PRAGMA user_version = ' + geoPackageConstants_1.GeoPackageConstants.USER_VERSION);
    };
    /**
     * gets the application_id from the sqlite file
     * @return {number}
     */
    GeoPackageConnection.prototype.getApplicationId = function () {
        return this.adapter.get('PRAGMA application_id').application_id;
    };
    /**
     * Convenience method
     * @see {module:db/geoPackageConnection~GeoPackageConnection}
     * @see {module:db/sqliteAdapter~Adapter}
     * @see {module:db/sqljsAdapter~Adapter}
     * @param  {string|Buffer|Uint8Array} filePath string path to an existing file or a path to where a new file will be created or a Buffer containing the contents of the file, if undefined, an in memory database is created
     * @return {Promise} that resolves
     */
    GeoPackageConnection.connect = function (filePath) {
        return new GeoPackageConnection(filePath).init();
    };
    /**
     * Convenience method
     * @param  {Object}   db       open database to connect to
     * @return {Promise}
     */
    GeoPackageConnection.connectWithDatabase = function (db) {
        return __awaiter(this, void 0, void 0, function () {
            var connection;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, new GeoPackageConnection(undefined).init()];
                    case 1:
                        connection = _a.sent();
                        connection.setDBConnection(db);
                        return [2 /*return*/, connection];
                }
            });
        });
    };
    return GeoPackageConnection;
}());
exports.GeoPackageConnection = GeoPackageConnection;
//# sourceMappingURL=geoPackageConnection.js.map