import { UserTable } from '../user/userTable';
import { GeoPackage } from '../geoPackage';
import { GeoPackageConnection } from './geoPackageConnection';
declare type TableCreatorScripts = 'spatial_reference_system' | 'contents' | 'geometry_columns' | 'tile_matrix_set' | 'tile_matrix' | 'data_columns' | 'data_column_constraints' | 'metadata' | 'metadata_reference' | 'extensions' | 'table_index' | 'geometry_index' | 'feature_tile_link' | 'extended_relations' | 'contents_id';
/**
 * `TableCreator` provides methods for creating the various standard tables in
 * a GeoPackage database.
 *
 * @class
 * @param {module:geoPackage~GeoPackage} geopackage GeoPackage object
 */
export declare class TableCreator {
    geopackage: GeoPackage;
    connection: GeoPackageConnection;
    constructor(geopackage: GeoPackage);
    /**
     * Creates all required tables and Spatial Reference Systems, in addition to EPSG:3857
     * @return {Promise<Boolean>}
     */
    createRequired(): Promise<boolean>;
    /**
     * Creates the spatial reference system tables
     * @return {Promise<Boolean>}
     */
    createSpatialReferenceSystem(): Promise<boolean>;
    /**
     * Creates the contents tables
     * @return {Promise<Boolean>}
     */
    createContents(): Promise<boolean>;
    /**
     * Creates the geometry columns tables
     * @return {Promise<Boolean>}
     */
    createGeometryColumns(): Promise<boolean>;
    /**
     * Creates the tile matrix set tables
     * @return {Promise<Boolean>}
     */
    createTileMatrixSet(): Promise<boolean>;
    /**
     * Creates the tile matrix tables
     * @return {Promise<Boolean>}
     */
    createTileMatrix(): Promise<boolean>;
    /**
     * Creates the data columns tables
     * @return {Promise<Boolean>}
     */
    createDataColumns(): Promise<boolean>;
    /**
     * Creates the data column constraints tables
     * @return {Promise<Boolean>}
     */
    createDataColumnConstraints(): Promise<boolean>;
    /**
     * Creates the metadata tables
     * @return {Promise<Boolean>}
     */
    createMetadata(): Promise<boolean>;
    /**
     * Creates the metadata reference tables
     * @return {Promise<Boolean>}
     */
    createMetadataReference(): Promise<boolean>;
    /**
     * Creates the extensions tables
     * @return {Promise<Boolean>}
     */
    createExtensions(): Promise<boolean>;
    /**
     * Creates the table index tables
     * @return {Promise<Boolean>}
     */
    createTableIndex(): Promise<boolean>;
    /**
     * Creates the geometry index tables
     * @return {Promise<Boolean>}
     */
    createGeometryIndex(): Promise<boolean>;
    /**
     * Creates the feature tile link tables
     * @return {Promise<Boolean>}
     */
    createFeatureTileLink(): Promise<boolean>;
    /**
     * Creates the extended relations tables
     * @return {Promise<Boolean>}
     */
    createExtendedRelations(): Promise<boolean>;
    /**
     * Creates the contentsId tables
     * @return {Promise<Boolean>}
     */
    createContentsId(): Promise<boolean>;
    /**
     * Creates all tables necessary for the specified table creation script name in the GeoPackage
     * @param  {string} creationScriptName creation scripts to run
     * @return {Promise<Boolean>}
     */
    createTable(creationScriptName: TableCreatorScripts): Promise<boolean>;
    /**
     * Create the given user table.
     *
     * @param {UserTable} userTable user table to create
     * @return {object} the result of {@link module:db/geoPackageConnection~GeoPackageConnection#run}
     * @throws {Error} if the table already exists
     */
    createUserTable(userTable: UserTable): {
        lastInsertRowid: number;
        changes: number;
    };
    static readonly tableCreationScripts: {
        spatial_reference_system: string[];
        contents: string[];
        geometry_columns: string[];
        tile_matrix_set: string[];
        tile_matrix: string[];
        data_columns: string[];
        data_column_constraints: string[];
        metadata: string[];
        metadata_reference: string[];
        extensions: string[];
        table_index: string[];
        geometry_index: string[];
        feature_tile_link: string[];
        extended_relations: string[];
        contents_id: string[];
    };
}
export {};
