import { GeoPackage } from '../geoPackage';
import { GeoPackageConnection } from '../db/geoPackageConnection';
import { Extension } from './extension';
import { ExtensionDao } from './extensionDao';
/**
 * Base Extension
 */
/**
 * Abstract base GeoPackage extension
 */
export declare abstract class BaseExtension {
    readonly geoPackage: GeoPackage;
    /**
     * Connecton to the GeoPackage
     */
    protected readonly connection: GeoPackageConnection;
    /**
     * ExtensionDao
     */
    readonly extensionsDao: ExtensionDao;
    /**
     * Name of the extension
     */
    extensionName: string;
    /**
     * Definition for the extension
     */
    extensionDefinition: string;
    /**
     * extension table name
     */
    tableName: string;
    /**
     *
     * @param geoPackage GeoPackage object
     */
    constructor(geoPackage: GeoPackage);
    /**
     * Get the extension or create as needed
     * @param  {String}   extensionName extension name
     * @param  {String}   tableName     table name
     * @param  {String}   columnName    column name
     * @param  {String}   definition    extension definition
     * @param  {String}   scopeType     extension scope type
     * @return {Promise<Extension>}
     */
    getOrCreate(extensionName: string, tableName: string | null, columnName: string | null, definition: string, scopeType: string): Promise<Extension>;
    /**
     * Get the extension for the name, table name and column name
     * @param  {String}   extensionName extension name
     * @param  {String}   tableName     table name
     * @param  {String}   columnName    column name
     * @return {Extension[]}
     */
    getExtension(extensionName: string, tableName: string | null, columnName: string | null): Extension[];
    /**
     * Determine if the GeoPackage has the extension
     * @param  {String}   extensionName extension name
     * @param  {String}   tableName     table name
     * @param  {String}   columnName    column name
     * @returns {Boolean} if the extension exists
     */
    hasExtension(extensionName: string, tableName: string, columnName: string): boolean;
    /**
     * Create the extension
     * @param {string} extensionName
     * @param {string} tableName
     * @param {string} columnName
     * @param {string} definition
     * @param {string} scopeType
     */
    createExtension(extensionName: string, tableName: string, columnName: string, definition: string, scopeType: string): number;
}
