import { Dao } from '../../dao/dao';
import { ContentsId } from './contentsId';
import { DBValue } from '../../db/dbAdapter';
/**
 * Contents Id Data Access Object
 * @constructor
 * @extends Dao
 */
export declare class ContentsIdDao extends Dao<ContentsId> {
    static readonly TABLE_NAME: string;
    static readonly COLUMN_ID: string;
    static readonly COLUMN_TABLE_NAME: string;
    readonly gpkgTableName: string;
    readonly idColumns: string[];
    /**
     * Create a {module:extension/contents.ContentsId} object
     * @return {module:extension/contents.ContentsId}
     */
    createObject(results?: Record<string, DBValue>): ContentsId;
    /**
     * Create the necessary tables for this dao
     * @return {Promise}
     */
    createTable(): Promise<boolean>;
    /**
     * Get all the table names
     * @return {string[]}
     */
    getTableNames(): string[];
    /**
     * Query by table name
     * @param  {string} tableName name of the table
     * @return {module:extension/contents.ContentsId}
     */
    queryForTableName(tableName: string): ContentsId;
    /**
     * Delete by tableName
     * @param  {string} tableName the table name to delete by
     * @return {number} number of deleted rows
     */
    deleteByTableName(tableName: string): number;
}
