/**
 * @module extension/contents
 */
import { BaseExtension } from '../baseExtension';
import { GeoPackage } from '../../geoPackage';
import { Extension } from '../extension';
import { ContentsIdDao } from './contentsIdDao';
import { Contents } from '../../core/contents/contents';
import { ContentsId } from './contentsId';
/**
 * Style extension
 */
export declare class ContentsIdExtension extends BaseExtension {
    static readonly EXTENSION_NAME: string;
    static readonly EXTENSION_AUTHOR: string;
    static readonly EXTENSION_NAME_NO_AUTHOR: string;
    static readonly EXTENSION_DEFINITION: string;
    contentsIdDao: ContentsIdDao;
    constructor(geoPackage: GeoPackage);
    /**
     * Get or create the contents id extension
     * @return {Promise}
     */
    getOrCreateExtension(): Promise<Extension>;
    /**
     * Get the ContentsIdDao
     * @returns {module:extension/contents.ContentsIdDao}
     */
    get dao(): ContentsIdDao;
    has(): boolean;
    /**
     * Get the ContentsId object
     * @param contents {module:core/contents.Contents}
     * @returns {module:extension/contents.ContentsId}
     */
    get(contents: Contents): ContentsId;
    /**
     * Get the ContentsId object
     * @param tableName
     * @returns {module:extension/contents.ContentsId}
     */
    getByTableName(tableName: string): ContentsId;
    /**
     * Get the ContentsId id
     * @param contents {module:core/contents.Contents}
     * @returns {Number}
     */
    getId(contents: Contents): number;
    /**
     * Get the ContentsId id
     * @param tableName
     * @returns {Number}
     */
    getIdByTableName(tableName: string): number;
    /**
     * Creates contentsId for contents
     * @param contents {module:core/contents.Contents}
     * @returns {module:extension/contents.ContentsId}
     */
    create(contents: Contents): ContentsId;
    /**
     * Creates contentsId for contents
     * @param tableName
     * @returns {module:extension/contents.ContentsId}
     */
    createWithTableName(tableName: string): ContentsId;
    /**
     * Creates contentsId for contents
     * @param contents {module:core/contents.Contents}
     * @returns {module:extension/contents.ContentsId}
     */
    createId(contents: Contents): ContentsId;
    /**
     * Creates contentsId for contents
     * @param tableName {string}
     * @returns {module:extension/contents.ContentsId}
     */
    createIdWithTableName(tableName: string): ContentsId;
    /**
     * Gets or creates contentsId for contents
     * @param contents {module:core/contents.Contents}
     * @returns {module:extension/contents.ContentsId}
     */
    getOrCreateId(contents: Contents): ContentsId;
    /**
     * Gets or creates contentsId for table name
     * @param tableName {string}
     * @returns {module:extension/contents.ContentsId}
     */
    getOrCreateIdByTableName(tableName: string): ContentsId;
    /**
     * Deletes contentsId for contents
     * @param contents {module:core/contents.Contents}
     */
    deleteId(contents: Contents): number;
    /**
     * Deletes contentId for table name
     * @param tableName {string}
     */
    deleteIdByTableName(tableName: string): number;
    /**
     * Number of contentsIds
     * @returns {number}
     */
    count(): number;
    /**
     * Create contentsIds for contents of type passed in
     * @param type defaults to ""
     * @returns {number}
     */
    createIds(type?: string): number;
    /**
     * Deletes ids by type
     * @param type
     * @returns {number}
     */
    deleteIds(type?: string): number;
    getIdsByType(type?: string): ContentsId[];
    /**
     * @typedef ContentsTableName
     * @type {Object}
     * @property {string} table_name the table name
     *
     * Get contents without contents ids
     * @param type
     * @returns {ContentsTableName[]} contentsTableNames
     */
    getMissing(type?: string): {
        table_name: string;
    }[];
    /**
     * Remove contents id extension
     */
    removeExtension(): void;
}
