/**
 * Indicates that a particular extension applies to a GeoPackage, a table in a
 * GeoPackage or a column of a table in a GeoPackage. An application that access
 * a GeoPackage can query the gpkg_extensions table instead of the contents of
 * all the user data tables to determine if it has the required capabilities to
 * read or write to tables with extensions, and to “fail fast” and return an
 * error message if it does not.
 */
export declare class Extension {
    static readonly EXTENSION_NAME_DIVIDER: string;
    static readonly READ_WRITE: string;
    static readonly WRITE_ONLY: string;
    /**
     * Name of the table that requires the extension. When NULL, the extension
     * is required for the entire GeoPackage. SHALL NOT be NULL when the
     * column_name is not NULL.
     */
    table_name: string;
    /**
     * Name of the column that requires the extension. When NULL, the extension
     * is required for the entire table.
     */
    column_name: string;
    /**
     * The case sensitive name of the extension that is required, in the form
     * <author>_<extension_name>.
     */
    extension_name: string;
    /**
     * Definition of the extension in the form specfied by the template in
     * GeoPackage Extension Template (Normative) or reference thereto.
     */
    definition: string;
    /**
     * Indicates scope of extension effects on readers / writers: read-write or
     * write-only in lowercase.
     */
    scope: string;
    setExtensionName(author: string, extensionName: string): void;
    get author(): string;
    get extensionNameNoAuthor(): string;
    static buildExtensionName(author: string, extensionName: string): string;
    static getAuthorWithExtensionName(extensionName: string): string;
    static getExtensionNameNoAuthor(extensionName: string): string;
}
