"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Indicates that a particular extension applies to a GeoPackage, a table in a
 * GeoPackage or a column of a table in a GeoPackage. An application that access
 * a GeoPackage can query the gpkg_extensions table instead of the contents of
 * all the user data tables to determine if it has the required capabilities to
 * read or write to tables with extensions, and to “fail fast” and return an
 * error message if it does not.
 */
var Extension = /** @class */ (function () {
    function Extension() {
    }
    Extension.prototype.setExtensionName = function (author, extensionName) {
        this.extension_name = Extension.buildExtensionName(author, extensionName);
    };
    Object.defineProperty(Extension.prototype, "author", {
        get: function () {
            return Extension.getAuthorWithExtensionName(this.extension_name);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Extension.prototype, "extensionNameNoAuthor", {
        get: function () {
            return Extension.getExtensionNameNoAuthor(this.extension_name);
        },
        enumerable: true,
        configurable: true
    });
    Extension.buildExtensionName = function (author, extensionName) {
        return author + Extension.EXTENSION_NAME_DIVIDER + extensionName;
    };
    Extension.getAuthorWithExtensionName = function (extensionName) {
        return extensionName.split(Extension.EXTENSION_NAME_DIVIDER)[0];
    };
    Extension.getExtensionNameNoAuthor = function (extensionName) {
        return extensionName.slice(extensionName.indexOf(Extension.EXTENSION_NAME_DIVIDER) + 1);
    };
    Extension.EXTENSION_NAME_DIVIDER = '_';
    Extension.READ_WRITE = 'read-write';
    Extension.WRITE_ONLY = 'write-only';
    return Extension;
}());
exports.Extension = Extension;
//# sourceMappingURL=extension.js.map