/**
 * MetadataExtension module.
 * @module extension/metadata
 */
import { BaseExtension } from '../baseExtension';
import { GeoPackage } from '../../geoPackage';
import { Extension } from '../extension';
/**
 * Metadata extension
 * @param  {module:geoPackage~GeoPackage} geoPackage GeoPackage object
 * @class
 * @extends BaseExtension
 */
export declare class MetadataExtension extends BaseExtension {
    static readonly EXTENSION_NAME: string;
    static readonly EXTENSION_Metadata_AUTHOR: string;
    static readonly EXTENSION_Metadata_NAME_NO_AUTHOR: string;
    static readonly EXTENSION_Metadata_DEFINITION: string;
    constructor(geoPackage: GeoPackage);
    /**
     * Get or create the metadata extension
     */
    getOrCreateExtension(): Promise<Extension>;
}
