"use strict";
/**
 * MetadataExtension module.
 * @module extension/metadata
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var baseExtension_1 = require("../baseExtension");
var extension_1 = require("../extension");
/**
 * Metadata extension
 * @param  {module:geoPackage~GeoPackage} geoPackage GeoPackage object
 * @class
 * @extends BaseExtension
 */
var MetadataExtension = /** @class */ (function (_super) {
    __extends(MetadataExtension, _super);
    function MetadataExtension(geoPackage) {
        var _this = _super.call(this, geoPackage) || this;
        _this.extensionName = MetadataExtension.EXTENSION_NAME;
        _this.extensionDefinition = MetadataExtension.EXTENSION_Metadata_DEFINITION;
        return _this;
    }
    /**
     * Get or create the metadata extension
     */
    MetadataExtension.prototype.getOrCreateExtension = function () {
        return this.getOrCreate(this.extensionName, null, null, this.extensionDefinition, extension_1.Extension.READ_WRITE);
    };
    MetadataExtension.EXTENSION_NAME = 'gpkg_metadata';
    MetadataExtension.EXTENSION_Metadata_AUTHOR = 'gpkg';
    MetadataExtension.EXTENSION_Metadata_NAME_NO_AUTHOR = 'metadata';
    MetadataExtension.EXTENSION_Metadata_DEFINITION = 'http://www.geopackage.org/spec/#extension_metadata';
    return MetadataExtension;
}(baseExtension_1.BaseExtension));
exports.MetadataExtension = MetadataExtension;
//# sourceMappingURL=index.js.map