"use strict";
/**
 * @module  extension/relatedTables
 */
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Dublin Core Metadata Initiative term types
 * @class
 */
var DublinCoreType = /** @class */ (function () {
    function DublinCoreType(name, synonyms) {
        this.name = name;
        this.synonyms = synonyms;
    }
    /**
     * Get the Dublin Core Type from the name
     * @param  {string} name name
     * @return {module:extension/relatedTables~DublinCoreType}
     */
    DublinCoreType.fromName = function (name) {
        for (var prop in DublinCoreType) {
            var type = DublinCoreType[prop];
            if (type.name === name) {
                return type;
            }
        }
        for (var prop in DublinCoreType) {
            var type = DublinCoreType[prop];
            if (type.synonyms) {
                for (var i = 0; i < type.synonyms.length; i++) {
                    if (type.synonyms[i] === name) {
                        return type;
                    }
                }
            }
        }
    };
    /**
     * A point or period of time associated with an event in the lifecycle of
     * the resource.
     * @type {Object}
     */
    DublinCoreType.DATE = new DublinCoreType('date');
    /**
     * An account of the resource.
     * @type {Object}
     */
    DublinCoreType.DESCRIPTION = new DublinCoreType('description');
    /**
     * The file format, physical medium, or dimensions of the resource.
     * @type {Object}
     */
    DublinCoreType.FORMAT = new DublinCoreType('format', ['content_type']);
    /**
     * An unambiguous reference to the resource within a given context.
     * @type {Object}
     */
    DublinCoreType.IDENTIFIER = new DublinCoreType('identifier', ['id']);
    /**
     * A related resource from which the described resource is derived.
     * @type {Object}
     */
    DublinCoreType.SOURCE = new DublinCoreType('source');
    /**
     * A name given to the resource.
     * @type {Object}
     */
    DublinCoreType.TITLE = new DublinCoreType('title');
    return DublinCoreType;
}());
exports.DublinCoreType = DublinCoreType;
//# sourceMappingURL=dublinCoreType.js.map