"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var userDao_1 = require("../../user/userDao");
var userTableReader_1 = require("../../user/userTableReader");
var mediaRow_1 = require("./mediaRow");
/**
 * MediaDao module.
 * @module extension/relatedTables
 */
/**
 * User Media DAO for reading user media data tables
 * @class
 * @param  {module:db/geoPackageConnection~GeoPackageConnection} connection        connection
 * @param  {string} table table name
 */
var MediaDao = /** @class */ (function (_super) {
    __extends(MediaDao, _super);
    function MediaDao(geoPackage, mediaTable) {
        var _this = _super.call(this, geoPackage, mediaTable) || this;
        _this.mediaTable = mediaTable;
        _this.mediaTable = mediaTable;
        return _this;
    }
    /**
     * Create a new media row
     * @return {module:extension/relatedTables~MediaRow}
     */
    MediaDao.prototype.newRow = function () {
        return new mediaRow_1.MediaRow(this.mediaTable);
    };
    /**
     * Create a media row with the column types and values
     * @param  {module:db/dataTypes[]} columnTypes  column types
     * @param  {module:dao/columnValues~ColumnValues[]} values      values
     * @return {module:extension/relatedTables~MediaRow}             media row
     */
    MediaDao.prototype.newRowWithColumnTypes = function (columnTypes, values) {
        return new mediaRow_1.MediaRow(this.mediaTable, columnTypes, values);
    };
    /**
     * Gets the media table
     * @return {module:extension/relatedTables~MediaTable}
     */
    MediaDao.prototype.getTable = function () {
        return this.mediaTable;
    };
    /**
     * Reads the table specified from the geopackage
     * @param  {module:geoPackage~GeoPackage} geoPackage      geopackage object
     * @param  {string} tableName       table name
     * @return {module:user/userDao~UserDao}
     */
    MediaDao.readTable = function (geoPackage, tableName) {
        var reader = new userTableReader_1.UserTableReader(tableName);
        var userTable = reader.readTable(geoPackage.database);
        return new MediaDao(geoPackage, userTable);
    };
    return MediaDao;
}(userDao_1.UserDao));
exports.MediaDao = MediaDao;
//# sourceMappingURL=mediaDao.js.map