/**
 * mediaTable module.
 * @module extension/relatedTables
 */
import { UserRelatedTable } from './userRelatedTable';
import { RelationType } from './relationType';
import { UserColumn } from '../../user/userColumn';
/**
 * Media Requirements Class User-Defined Related Data Table
 * @class
 * @extends UserRelatedTable
 * @param  {string} tableName table name
 * @param  {module:user/userColumn~UserColumn[]} columns   media columns
 * @param {string[]} requiredColumns required column names
 */
export declare class MediaTable extends UserRelatedTable {
    static readonly RELATION_TYPE: RelationType;
    static readonly COLUMN_ID: string;
    static readonly COLUMN_DATA: string;
    static readonly COLUMN_CONTENT_TYPE: string;
    readonly TABLE_TYPE: string;
    constructor(tableName: string, columns?: UserColumn[], requiredColumns?: string[]);
    getTableType(): string;
    /**
     * Get the primary key id column
     * @return {module:user/userColumn~UserColumn}
     */
    getIdColumn(): UserColumn;
    /**
     * Get the data column
     * @return {module:user/userColumn~UserColumn}
     */
    getDataColumn(): UserColumn;
    /**
     * Get the content type column
     * @return {module:user/userColumn~UserColumn}
     */
    getContentTypeColumn(): UserColumn;
    /**
     * Create a media table with a minimum required columns followed by the additional columns
     * @param  {string} tableName         name of the table
     * @param  {module:user/userColumn~UserColumn[]} [additionalColumns] additional columns
     * @return {module:extension/relatedTables~MediaTable}
     */
    static create(tableName: string, additionalColumns?: UserColumn[]): MediaTable;
    /**
     * Get the required columns
     * @param  {string} [idColumnName=id] id column name
     * @return {string[]}
     */
    static requiredColumns(idColumnName?: string): string[];
    /**
     * Get the number of required columns
     * @return {Number}
     */
    static numRequiredColumns(): number;
    /**
     * Create the required columns
     * @param  {Number} [startingIndex=0] starting index of the required columns
     * @param  {string} [idColumnName=id]  id column name
     * @return {module:user/userColumn~UserColumn[]}
     */
    static createRequiredColumns(startingIndex?: number, idColumnName?: string): UserColumn[];
    /**
     * Create the primary key id column
     * @param  {Number} index        index of the column
     * @param  {string} idColumnName name of the id column
     * @return {module:user/userColumn~UserColumn}
     */
    static createIdColumn(index: number, idColumnName: string): UserColumn;
    /**
     * Create the data column
     * @param  {Number} index        index of the column
     * @return {module:user/userColumn~UserColumn}
     */
    static createDataColumn(index: number): UserColumn;
    /**
     * Create the content type column
     * @param  {Number} index        index of the column
     * @return {module:user/userColumn~UserColumn}
     */
    static createContentTypeColumn(index: number): UserColumn;
}
