"use strict";
/**
 * @module extension/relatedTables
 */
Object.defineProperty(exports, "__esModule", { value: true });
var contentsDao_1 = require("../../core/contents/contentsDao");
/**
 * Spec supported User-Defined Related Data Tables
 * @class
 */
var RelationType = /** @class */ (function () {
    function RelationType(name, dataType) {
        this.name = name;
        this.dataType = dataType;
    }
    /**
     * Get the relation type from the name
     * @param  {string} name name
     * @return {module:extension/relatedTables~RelationType}
     */
    RelationType.fromName = function (name) {
        return RelationType[name.toUpperCase()];
    };
    /**
     * Link features with other features
     * @type {Object}
     */
    RelationType.FEATURES = new RelationType('features', contentsDao_1.ContentsDao.GPKG_CDT_FEATURES_NAME);
    /**
     * Relate sets of tabular text or numeric data
     * @type {Object}
     */
    RelationType.SIMPLE_ATTRIBUTES = new RelationType('simple_attributes', contentsDao_1.ContentsDao.GPKG_CDT_ATTRIBUTES_NAME);
    /**
     * Relate features or attributes to multimedia files such as pictures and videos
     * @type {Object}
     */
    RelationType.MEDIA = new RelationType('media', contentsDao_1.ContentsDao.GPKG_CDT_ATTRIBUTES_NAME);
    /**
     * Attribute type relation
     * @type {Object}
     */
    RelationType.ATTRIBUTES = new RelationType('attributes', contentsDao_1.ContentsDao.GPKG_CDT_ATTRIBUTES_NAME);
    /**
     * Tile type relation
     * @type {Object}
     */
    RelationType.TILES = new RelationType('tiles', contentsDao_1.ContentsDao.GPKG_CDT_TILES_NAME);
    return RelationType;
}());
exports.RelationType = RelationType;
//# sourceMappingURL=relationType.js.map