"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * SimpleAttributesDao module.
 * @module extension/relatedTables
 */
var userDao_1 = require("../../user/userDao");
var simpleAttributesRow_1 = require("./simpleAttributesRow");
/**
 * User Simple Attributes DAO for reading user simple attributes data tables
 * @class
 * @extends UserDao
 * @param  {module:db/geoPackageConnection~GeoPackageConnection} connection        connection
 * @param  {string} table table name
 */
var SimpleAttributesDao = /** @class */ (function (_super) {
    __extends(SimpleAttributesDao, _super);
    function SimpleAttributesDao(geoPackage, simpleAttributesTable) {
        var _this = _super.call(this, geoPackage, simpleAttributesTable) || this;
        _this.simpleAttributesTable = simpleAttributesTable;
        return _this;
    }
    /**
     * Create a new {module:extension/relatedTables~SimpleAttributesRow}
     * @return {module:extension/relatedTables~SimpleAttributesRow}
     */
    SimpleAttributesDao.prototype.newRow = function () {
        return new simpleAttributesRow_1.SimpleAttributesRow(this.simpleAttributesTable);
    };
    /**
     * Create a new {module:extension/relatedTables~SimpleAttributesRow} with the column types and values
     * @param  {module:db/dataTypes[]} columnTypes  column types
     * @param  {module:dao/columnValues~ColumnValues[]} values      values
     * @return {module:extension/relatedTables~SimpleAttributesRow}             simple attributes row
     */
    SimpleAttributesDao.prototype.newRowWithColumnTypes = function (columnTypes, values) {
        return new simpleAttributesRow_1.SimpleAttributesRow(this.simpleAttributesTable, columnTypes, values);
    };
    /**
     * Gets the {module:extension/relatedTables~SimpleAttributesTable}
     * @return {module:extension/relatedTables~SimpleAttributesTable}
     */
    SimpleAttributesDao.prototype.getTable = function () {
        return this.simpleAttributesTable;
    };
    /**
     * Get the simple attributes rows from this table by ids
     * @param  {Number[]} ids array of ids
     * @return {module:extension/relatedTables~SimpleAttributesRow[]}
     */
    SimpleAttributesDao.prototype.getRows = function (ids) {
        var simpleAttributesRows = [];
        for (var i = 0; i < ids.length; i++) {
            var row = this.queryForId(ids[i]);
            if (row) {
                simpleAttributesRows.push(row);
            }
        }
        return simpleAttributesRows;
    };
    return SimpleAttributesDao;
}(userDao_1.UserDao));
exports.SimpleAttributesDao = SimpleAttributesDao;
//# sourceMappingURL=simpleAttributesDao.js.map