"use strict";
/**
 * SimpleAttributesRow module.
 * @module extension/relatedTables
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var userRow_1 = require("../../user/userRow");
/**
 * User Simple Attributes Row containing the values from a single result set row
 * @class
 * @extends UserRow
 * @param  {module:extension/relatedTables~SimpleAttributesTable} simpleAttributesTable simple attributes table
 * @param  {module:db/dataTypes[]} columnTypes  column types
 * @param  {module:dao/columnValues~ColumnValues[]} values      values
 */
var SimpleAttributesRow = /** @class */ (function (_super) {
    __extends(SimpleAttributesRow, _super);
    function SimpleAttributesRow(simpleAttributesTable, columnTypes, values) {
        var _this = _super.call(this, simpleAttributesTable, columnTypes, values) || this;
        _this.simpleAttributesTable = simpleAttributesTable;
        return _this;
    }
    /**
     * Gets the primary key id column
     * @return {module:user/userColumn~UserColumn}
     */
    SimpleAttributesRow.prototype.getIdColumn = function () {
        return this.simpleAttributesTable.getIdColumn();
    };
    Object.defineProperty(SimpleAttributesRow.prototype, "id", {
        /**
         * Gets the id
         * @return {Number}
         */
        get: function () {
            return this.getValueWithColumnName(this.getIdColumn().name);
        },
        enumerable: true,
        configurable: true
    });
    return SimpleAttributesRow;
}(userRow_1.UserRow));
exports.SimpleAttributesRow = SimpleAttributesRow;
//# sourceMappingURL=simpleAttributesRow.js.map