"use strict";
/**
 * simpleAttributesTable module.
 * @module extension/relatedTables
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var userRelatedTable_1 = require("./userRelatedTable");
var relationType_1 = require("./relationType");
var userColumn_1 = require("../../user/userColumn");
var dataTypes_1 = require("../../db/dataTypes");
/**
 * Simple Attributes Requirements Class User-Defined Related Data Table
 * @class
 * @extends UserRelatedTable
 * @param  {string} tableName table name
 * @param  {module:user/userColumn~UserColumn[]} columns   attribute columns
 * @param {string[]} requiredColumns required column names
 */
var SimpleAttributesTable = /** @class */ (function (_super) {
    __extends(SimpleAttributesTable, _super);
    function SimpleAttributesTable(tableName, columns, requiredColumns) {
        var _this = _super.call(this, tableName, SimpleAttributesTable.RELATION_TYPE.name, SimpleAttributesTable.RELATION_TYPE.dataType, columns, requiredColumns) || this;
        _this.TABLE_TYPE = 'simple_attributes';
        _this.validateColumns();
        return _this;
    }
    /**
     * Validate that Simple Attributes columns to verify at least one non id
     * column exists and that all columns are simple data types
     */
    SimpleAttributesTable.prototype.validateColumns = function () {
        var columns = this.columns;
        if (columns.length < 2) {
            throw new Error('Simple Attributes Tables require at least one non id column');
        }
        for (var i = 0; i < columns.length; i++) {
            var column = columns[i];
            if (!SimpleAttributesTable.isSimple(column)) {
                throw new Error('Simple Attributes Tables only support simple data types. Column: ' +
                    column.name +
                    ', Non Simple Data Type: ' +
                    column.dataType);
            }
        }
        return true;
    };
    /**
     * Get the column index of the id column
     * @return {Number}
     */
    SimpleAttributesTable.prototype.getIdColumnIndex = function () {
        return this.pkIndex;
    };
    /**
     * Get the primary key id column
     * @return {module:user/userColumn~UserColumn}
     */
    SimpleAttributesTable.prototype.getIdColumn = function () {
        return this.getPkColumn();
    };
    /**
     * Create a simple attributes table with the columns
     * @param  {string} tableName name of the table
     * @param  {module:user/userColumn~UserColumn[]} additionalColumns additional columns
     * @return {module:extension/relatedTables~SimpleAttributesTable}
     */
    SimpleAttributesTable.create = function (tableName, additionalColumns) {
        var tableColumns = SimpleAttributesTable.createRequiredColumns(0);
        if (additionalColumns) {
            tableColumns = tableColumns.concat(additionalColumns);
        }
        return new SimpleAttributesTable(tableName, tableColumns, SimpleAttributesTable.requiredColumns());
    };
    /**
     * Get the required columns
     * @param  {string} [idColumnName=id] id column name
     * @return {string[]}
     */
    SimpleAttributesTable.requiredColumns = function (idColumnName) {
        if (idColumnName === void 0) { idColumnName = SimpleAttributesTable.COLUMN_ID; }
        var requiredColumns = [];
        requiredColumns.push(idColumnName);
        return requiredColumns;
    };
    /**
     * Get the number of required columns
     * @return {Number}
     */
    SimpleAttributesTable.numRequiredColumns = function () {
        return SimpleAttributesTable.requiredColumns().length;
    };
    /**
     * Create the required columns
     * @param  {Number} [startingIndex=0] starting index of the required columns
     * @param  {string} [idColumnName=id]  id column name
     * @return {module:user/userColumn~UserColumn[]}
     */
    SimpleAttributesTable.createRequiredColumns = function (startingIndex, idColumnName) {
        if (startingIndex === void 0) { startingIndex = 0; }
        if (idColumnName === void 0) { idColumnName = 'id'; }
        return [SimpleAttributesTable.createIdColumn(startingIndex++, idColumnName || SimpleAttributesTable.COLUMN_ID)];
    };
    /**
     * Create the primary key id column
     * @param  {Number} index        index of the column
     * @param  {string} idColumnName name of the id column
     * @return {module:user/userColumn~UserColumn}
     */
    SimpleAttributesTable.createIdColumn = function (index, idColumnName) {
        return userColumn_1.UserColumn.createPrimaryKeyColumnWithIndexAndName(index, idColumnName);
    };
    /**
     * Determine if the column is a simple column
     * @param  {module:user/userColumn~UserColumn} column column to check
     * @return {Boolean}
     */
    SimpleAttributesTable.isSimple = function (column) {
        return column.notNull && SimpleAttributesTable.isSimpleDataType(column.dataType);
    };
    /**
     * Determine if the data type is a simple type: TEXT, INTEGER, or REAL
     * @param {module:db/dataTypes~GPKGDataType} dataType
     * @return {Boolean}
     */
    SimpleAttributesTable.isSimpleDataType = function (dataType) {
        return dataType !== dataTypes_1.DataTypes.BLOB && dataType !== dataTypes_1.DataTypes.GEOMETRY;
    };
    SimpleAttributesTable.RELATION_TYPE = relationType_1.RelationType.SIMPLE_ATTRIBUTES;
    SimpleAttributesTable.COLUMN_ID = 'id';
    return SimpleAttributesTable;
}(userRelatedTable_1.UserRelatedTable));
exports.SimpleAttributesTable = SimpleAttributesTable;
//# sourceMappingURL=simpleAttributesTable.js.map