import { GeoPackage } from '../../geoPackage';
import { BaseExtension } from '../baseExtension';
import { Extension } from '../extension';
import { RTreeIndexDao } from './rtreeIndexDao';
import { FeatureDao } from '../../features/user/featureDao';
import { FeatureRow } from '../../features/user/featureRow';
/**
 * RTreeIndex extension
 * @class RTreeIndex
 * @extends BaseExtension
 * @param {module:geoPackage~GeoPackage} geoPackage The GeoPackage object
 */
export declare class RTreeIndex extends BaseExtension {
    tableName: string;
    primaryKeyColumn: string;
    columnName: string;
    featureCount: number;
    rtreeIndexDao: RTreeIndexDao;
    extensionExists: boolean;
    constructor(geoPackage: GeoPackage, featureDao: FeatureDao<FeatureRow>);
    getRTreeIndexExtension(): Extension[];
    getOrCreateExtension(): Promise<Extension>;
    /**
     *
     * @param {Function} [progress] progress function
     * @returns {Promise}
     */
    create(progress?: Function): Promise<Extension[]>;
    createAllTriggers(): boolean;
    loadRTreeIndex(): boolean;
    createRTreeIndex(): boolean;
    createAllFunctions(): void;
    createMinXFunction(): void;
    createMinYFunction(): void;
    createMaxXFunction(): void;
    createMaxYFunction(): void;
    createIsEmptyFunction(): void;
}
