"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var baseExtension_1 = require("../baseExtension");
var extension_1 = require("../extension");
var rtreeIndexDao_1 = require("./rtreeIndexDao");
var envelopeBuilder_1 = require("../../geom/envelopeBuilder");
var geometryData_1 = require("../../geom/geometryData");
/**
 * RTreeIndex extension
 * @class RTreeIndex
 * @extends BaseExtension
 * @param {module:geoPackage~GeoPackage} geoPackage The GeoPackage object
 */
var RTreeIndex = /** @class */ (function (_super) {
    __extends(RTreeIndex, _super);
    function RTreeIndex(geoPackage, featureDao) {
        var _this = _super.call(this, geoPackage) || this;
        _this.extensionName = extension_1.Extension.buildExtensionName(rtreeIndexDao_1.RTreeIndexDao.EXTENSION_RTREE_INDEX_AUTHOR, rtreeIndexDao_1.RTreeIndexDao.EXTENSION_RTREE_INDEX_NAME_NO_AUTHOR);
        _this.extensionDefinition = rtreeIndexDao_1.RTreeIndexDao.EXTENSION_RTREE_INDEX_DEFINITION;
        _this.tableName = featureDao.table_name;
        _this.primaryKeyColumn = featureDao.idColumns[0];
        _this.columnName = featureDao.getGeometryColumnName();
        _this.featureCount = featureDao.count();
        _this.rtreeIndexDao = new rtreeIndexDao_1.RTreeIndexDao(geoPackage, featureDao);
        _this.extensionExists = _this.hasExtension(_this.extensionName, _this.tableName, _this.columnName);
        return _this;
    }
    RTreeIndex.prototype.getRTreeIndexExtension = function () {
        return this.getExtension(this.extensionName, this.tableName, this.columnName);
    };
    RTreeIndex.prototype.getOrCreateExtension = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.getOrCreate(this.extensionName, this.tableName, this.columnName, this.extensionDefinition, extension_1.Extension.WRITE_ONLY)];
            });
        });
    };
    /**
     *
     * @param {Function} [progress] progress function
     * @returns {Promise}
     */
    RTreeIndex.prototype.create = function (progress) {
        return __awaiter(this, void 0, void 0, function () {
            var safeProgress;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        safeProgress = progress || function () { };
                        if (this.extensionExists) {
                            return [2 /*return*/, this.getRTreeIndexExtension()];
                        }
                        return [4 /*yield*/, this.getOrCreate(this.extensionName, this.tableName, this.columnName, rtreeIndexDao_1.RTreeIndexDao.EXTENSION_RTREE_INDEX_DEFINITION, extension_1.Extension.WRITE_ONLY)];
                    case 1:
                        _a.sent();
                        this.createAllFunctions();
                        this.createRTreeIndex();
                        safeProgress({
                            description: 'Creating Feature Index',
                            count: 0,
                            totalCount: this.featureCount,
                            layer: this.tableName,
                        });
                        this.loadRTreeIndex();
                        this.createAllTriggers();
                        return [2 /*return*/, this.getRTreeIndexExtension()];
                }
            });
        });
    };
    RTreeIndex.prototype.createAllTriggers = function () {
        var insertTrigger = 'CREATE TRIGGER rtree_' +
            this.tableName +
            '_' +
            this.columnName +
            '_insert AFTER INSERT ON ' +
            this.tableName +
            '  WHEN (new.' +
            this.columnName +
            ' NOT NULL AND NOT ST_IsEmpty(NEW.' +
            this.columnName +
            ')) ' +
            'BEGIN ' +
            '  INSERT OR REPLACE INTO rtree_' +
            this.tableName +
            '_' +
            this.columnName +
            ' VALUES (' +
            '    NEW.' +
            this.primaryKeyColumn +
            ',' +
            '    ST_MinX(NEW.' +
            this.columnName +
            '), ST_MaxX(NEW.' +
            this.columnName +
            '), ' +
            '    ST_MinY(NEW.' +
            this.columnName +
            '), ST_MaxY(NEW.' +
            this.columnName +
            ') ' +
            '  ); ' +
            'END;';
        var update1Trigger = 'CREATE TRIGGER rtree_' +
            this.tableName +
            '_' +
            this.columnName +
            '_update1 AFTER UPDATE OF ' +
            this.columnName +
            ' ON ' +
            this.tableName +
            '  WHEN OLD.' +
            this.primaryKeyColumn +
            ' = NEW.' +
            this.primaryKeyColumn +
            ' AND ' +
            '     (NEW.' +
            this.columnName +
            ' NOTNULL AND NOT ST_IsEmpty(NEW.' +
            this.columnName +
            ')) ' +
            'BEGIN ' +
            '  INSERT OR REPLACE INTO rtree_' +
            this.tableName +
            '_' +
            this.columnName +
            ' VALUES (' +
            '    NEW.' +
            this.primaryKeyColumn +
            ',' +
            '    ST_MinX(NEW.' +
            this.columnName +
            '), ST_MaxX(NEW.' +
            this.columnName +
            '), ' +
            '    ST_MinY(NEW.' +
            this.columnName +
            '), ST_MaxY(NEW.' +
            this.columnName +
            ') ' +
            '  ); ' +
            'END;';
        var update2Trigger = 'CREATE TRIGGER rtree_' +
            this.tableName +
            '_' +
            this.columnName +
            '_update2 AFTER UPDATE OF ' +
            this.columnName +
            ' ON ' +
            this.tableName +
            '  WHEN OLD.' +
            this.primaryKeyColumn +
            ' = NEW.' +
            this.primaryKeyColumn +
            ' AND ' +
            '       (NEW.' +
            this.columnName +
            ' ISNULL OR ST_IsEmpty(NEW.' +
            this.columnName +
            ')) ' +
            'BEGIN ' +
            '  DELETE FROM rtree_' +
            this.tableName +
            '_' +
            this.columnName +
            ' WHERE id = OLD.' +
            this.primaryKeyColumn +
            '; ' +
            'END;';
        var update3Trigger = 'CREATE TRIGGER rtree_' +
            this.tableName +
            '_' +
            this.columnName +
            '_update3 AFTER UPDATE OF ' +
            this.columnName +
            ' ON ' +
            this.tableName +
            '  WHEN OLD.' +
            this.primaryKeyColumn +
            ' != NEW.' +
            this.primaryKeyColumn +
            ' AND ' +
            '       (NEW.' +
            this.columnName +
            ' NOTNULL AND NOT ST_IsEmpty(NEW.' +
            this.columnName +
            ')) ' +
            'BEGIN ' +
            '  DELETE FROM rtree_' +
            this.tableName +
            '_' +
            this.columnName +
            ' WHERE id = OLD.' +
            this.primaryKeyColumn +
            '; ' +
            '  INSERT OR REPLACE INTO rtree_' +
            this.tableName +
            '_' +
            this.columnName +
            ' VALUES (' +
            '    NEW.' +
            this.primaryKeyColumn +
            ', ' +
            '    ST_MinX(NEW.' +
            this.columnName +
            '), ST_MaxX(NEW.' +
            this.columnName +
            '), ' +
            '    ST_MinY(NEW.' +
            this.columnName +
            '), ST_MaxY(NEW.' +
            this.columnName +
            ')' +
            '  ); ' +
            'END;';
        var update4Trigger = 'CREATE TRIGGER rtree_' +
            this.tableName +
            '_' +
            this.columnName +
            '_update4 AFTER UPDATE ON ' +
            this.tableName +
            '  WHEN OLD.' +
            this.primaryKeyColumn +
            ' != NEW.' +
            this.primaryKeyColumn +
            ' AND ' +
            '       (NEW.' +
            this.columnName +
            ' ISNULL OR ST_IsEmpty(NEW.' +
            this.columnName +
            ')) ' +
            'BEGIN ' +
            '  DELETE FROM rtree_' +
            this.tableName +
            '_' +
            this.columnName +
            ' WHERE id IN (OLD.' +
            this.primaryKeyColumn +
            ', NEW.' +
            this.primaryKeyColumn +
            '); ' +
            'END;';
        var deleteTrigger = 'CREATE TRIGGER rtree_' +
            this.tableName +
            '_' +
            this.columnName +
            '_delete AFTER DELETE ON ' +
            this.tableName +
            '  WHEN old.' +
            this.columnName +
            ' NOT NULL ' +
            'BEGIN' +
            '  DELETE FROM rtree_' +
            this.tableName +
            '_' +
            this.columnName +
            ' WHERE id = OLD.' +
            this.primaryKeyColumn +
            '; ' +
            'END;';
        var changes = 0;
        changes += this.connection.run(insertTrigger).changes;
        changes += this.connection.run(update1Trigger).changes;
        changes += this.connection.run(update2Trigger).changes;
        changes += this.connection.run(update3Trigger).changes;
        changes += this.connection.run(update4Trigger).changes;
        changes += this.connection.run(deleteTrigger).changes;
        return changes === 6;
    };
    RTreeIndex.prototype.loadRTreeIndex = function () {
        return (this.connection.run('INSERT OR REPLACE INTO rtree_' +
            this.tableName +
            '_' +
            this.columnName +
            ' SELECT ' +
            this.primaryKeyColumn +
            ', st_minx(' +
            this.columnName +
            '), st_maxx(' +
            this.columnName +
            '), st_miny(' +
            this.columnName +
            '), st_maxy(' +
            this.columnName +
            ') FROM ' +
            this.tableName).changes === 1);
    };
    RTreeIndex.prototype.createRTreeIndex = function () {
        return (this.connection.run('CREATE VIRTUAL TABLE rtree_' +
            this.tableName +
            '_' +
            this.columnName +
            ' USING rtree(id, minx, maxx, miny, maxy)').changes === 1);
    };
    RTreeIndex.prototype.createAllFunctions = function () {
        this.createMinXFunction();
        this.createMaxXFunction();
        this.createMinYFunction();
        this.createMaxYFunction();
        this.createIsEmptyFunction();
    };
    RTreeIndex.prototype.createMinXFunction = function () {
        this.connection.registerFunction('ST_MinX', function (buffer) {
            var geom = new geometryData_1.GeometryData(buffer);
            var envelope = geom.envelope;
            if (!envelope) {
                envelope = envelopeBuilder_1.EnvelopeBuilder.buildEnvelopeWithGeometry(geom.geometry);
            }
            return envelope.minX;
        });
    };
    RTreeIndex.prototype.createMinYFunction = function () {
        this.connection.registerFunction('ST_MinY', function (buffer) {
            var geom = new geometryData_1.GeometryData(buffer);
            var envelope = geom.envelope;
            if (!envelope) {
                envelope = envelopeBuilder_1.EnvelopeBuilder.buildEnvelopeWithGeometry(geom.geometry);
            }
            return envelope.minY;
        });
    };
    RTreeIndex.prototype.createMaxXFunction = function () {
        this.connection.registerFunction('ST_MaxX', function (buffer) {
            var geom = new geometryData_1.GeometryData(buffer);
            var envelope = geom.envelope;
            if (!envelope) {
                envelope = envelopeBuilder_1.EnvelopeBuilder.buildEnvelopeWithGeometry(geom.geometry);
            }
            return envelope.maxX;
        });
    };
    RTreeIndex.prototype.createMaxYFunction = function () {
        this.connection.registerFunction('ST_MaxY', function (buffer) {
            var geom = new geometryData_1.GeometryData(buffer);
            var envelope = geom.envelope;
            if (!envelope) {
                envelope = envelopeBuilder_1.EnvelopeBuilder.buildEnvelopeWithGeometry(geom.geometry);
            }
            return envelope.maxY;
        });
    };
    RTreeIndex.prototype.createIsEmptyFunction = function () {
        this.connection.registerFunction('ST_IsEmpty', function (buffer) {
            var geom = new geometryData_1.GeometryData(buffer);
            var empty = !geom || geom.empty || !geom.geometry;
            return empty ? 1 : 0;
        });
    };
    return RTreeIndex;
}(baseExtension_1.BaseExtension));
exports.RTreeIndex = RTreeIndex;
//# sourceMappingURL=rtreeIndex.js.map