"use strict";
/**
 * SchemaExtension module.
 * @module SchemaExtension
 * @see module:extension/BaseExtension
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var baseExtension_1 = require("../baseExtension");
var extension_1 = require("../extension");
var SchemaExtension = /** @class */ (function (_super) {
    __extends(SchemaExtension, _super);
    function SchemaExtension(geoPackage) {
        var _this = _super.call(this, geoPackage) || this;
        _this.extensionName = SchemaExtension.EXTENSION_NAME;
        _this.extensionDefinition = SchemaExtension.EXTENSION_SCHEMA_DEFINITION;
        return _this;
    }
    SchemaExtension.prototype.getOrCreateExtension = function () {
        return this.getOrCreate(this.extensionName, null, null, this.extensionDefinition, extension_1.Extension.READ_WRITE);
    };
    SchemaExtension.EXTENSION_NAME = 'gpkg_schema';
    SchemaExtension.EXTENSION_SCHEMA_AUTHOR = 'gpkg';
    SchemaExtension.EXTENSION_SCHEMA_NAME_NO_AUTHOR = 'schema';
    SchemaExtension.EXTENSION_SCHEMA_DEFINITION = 'http://www.geopackage.org/spec/#extension_schema';
    return SchemaExtension;
}(baseExtension_1.BaseExtension));
exports.SchemaExtension = SchemaExtension;
//# sourceMappingURL=index.js.map