import { IconTable } from './iconTable';
import { MediaRow } from '../relatedTables/mediaRow';
import { UserColumn } from '../../user/userColumn';
import { DBValue } from '../../db/dbAdapter';
import { DataTypes } from '../../db/dataTypes';
/**
 * @memberOf module:extension/style
 * @class IconRow
 */
/**
 * Icon Row
 * @extends MediaRow
 * @param  {module:extension/style.IconTable} iconTable  icon table
 * @param  {module:db/dataTypes[]} columnTypes  column types
 * @param  {module:dao/columnValues~ColumnValues[]} values      values
 * @constructor
 */
export declare class IconRow extends MediaRow {
    iconTable: IconTable;
    constructor(iconTable: IconTable, columnTypes?: {
        [key: string]: DataTypes;
    }, values?: Record<string, DBValue>);
    /**
     * Get the name column
     * @return {module:user/userColumn~UserColumn}
     */
    getNameColumn(): UserColumn;
    /**
     * Gets the name
     * @return {String}
     */
    getName(): string;
    /**
     * Sets the name for the row
     * @param {String} name name
     */
    setName(name: string): void;
    /**
     * Get the description column
     * @return {module:user/userColumn~UserColumn}
     */
    getDescriptionColumn(): UserColumn;
    /**
     * Gets the description
     * @return {String}
     */
    getDescription(): string;
    /**
     * Sets the description for the row
     * @param {string} description description
     */
    setDescription(description: string): void;
    /**
     * Get the width column
     * @return {module:user/userColumn~UserColumn}
     */
    getWidthColumn(): UserColumn;
    /**
     * Gets the width
     * @return {Number}
     */
    getWidth(): number;
    /**
     * Sets the width for the row
     * @param {Number} width width
     */
    setWidth(width: number): void;
    /**
     * Get the width or derived width from the icon data and scaled as needed
     * for the height
     *
     * @return {Number}  derived width
     */
    getDerivedWidth(): number;
    /**
     * Get the height column
     * @return {module:user/userColumn~UserColumn}
     */
    getHeightColumn(): UserColumn;
    /**
     * Gets the height
     * @return {Number}
     */
    getHeight(): number;
    /**
     * Sets the height for the row
     * @param {Number} height height
     */
    setHeight(height: number): void;
    /**
     * Get the height or derived height from the icon data and scaled as needed
     * for the width
     *
     * @return {Number} derived height
     */
    getDerivedHeight(): number;
    /**
     * Get the derived width and height from the values and icon data, scaled as needed
     * @return {Number[]} derived dimensions array with two values, width at index 0, height at index 1
     */
    getDerivedDimensions(): number[];
    /**
     * Get the anchor_u column
     * @return {module:user/userColumn~UserColumn}
     */
    getAnchorUColumn(): UserColumn;
    /**
     * Gets the anchor_u
     * @return {Number}
     */
    getAnchorU(): number;
    /**
     * Sets the anchor_u for the row
     * @param {Number} anchor_u anchor_u
     */
    setAnchorU(anchorU: number): void;
    /**
     * Get the anchor u value or the default value of 0.5
     * @return {Number} anchor u value
     */
    getAnchorUOrDefault(): number;
    /**
     * Get the anchor_v column
     * @return {module:user/userColumn~UserColumn}
     */
    getAnchorVColumn(): UserColumn;
    /**
     * Gets the anchor_v
     * @return {Number}
     */
    getAnchorV(): number;
    /**
     * Sets the anchor_v for the row
     * @param {Number} anchor_v anchor_v
     */
    setAnchorV(anchorV: number): void;
    /**
     * Get the anchor v value or the default value of 1.0
     * @return {Number} anchor v value
     */
    getAnchorVOrDefault(): number;
    /**
     * Validate the anchor value
     * @param {Number} anchor anchor
     */
    validateAnchor(anchor: number): boolean;
}
