"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var mediaRow_1 = require("../relatedTables/mediaRow");
var imageUtils_1 = require("../../tiles/imageUtils");
/**
 * @memberOf module:extension/style
 * @class IconRow
 */
/**
 * Icon Row
 * @extends MediaRow
 * @param  {module:extension/style.IconTable} iconTable  icon table
 * @param  {module:db/dataTypes[]} columnTypes  column types
 * @param  {module:dao/columnValues~ColumnValues[]} values      values
 * @constructor
 */
var IconRow = /** @class */ (function (_super) {
    __extends(IconRow, _super);
    function IconRow(iconTable, columnTypes, values) {
        var _this = _super.call(this, iconTable, columnTypes, values) || this;
        _this.iconTable = iconTable;
        return _this;
    }
    /**
     * Get the name column
     * @return {module:user/userColumn~UserColumn}
     */
    IconRow.prototype.getNameColumn = function () {
        return this.iconTable.getNameColumn();
    };
    /**
     * Gets the name
     * @return {String}
     */
    IconRow.prototype.getName = function () {
        return this.getValueWithColumnName(this.getNameColumn().name);
    };
    /**
     * Sets the name for the row
     * @param {String} name name
     */
    IconRow.prototype.setName = function (name) {
        this.setValueWithColumnName(this.getNameColumn().name, name);
    };
    /**
     * Get the description column
     * @return {module:user/userColumn~UserColumn}
     */
    IconRow.prototype.getDescriptionColumn = function () {
        return this.iconTable.getDescriptionColumn();
    };
    /**
     * Gets the description
     * @return {String}
     */
    IconRow.prototype.getDescription = function () {
        return this.getValueWithColumnName(this.getDescriptionColumn().name);
    };
    /**
     * Sets the description for the row
     * @param {string} description description
     */
    IconRow.prototype.setDescription = function (description) {
        this.setValueWithColumnName(this.getDescriptionColumn().name, description);
    };
    /**
     * Get the width column
     * @return {module:user/userColumn~UserColumn}
     */
    IconRow.prototype.getWidthColumn = function () {
        return this.iconTable.getWidthColumn();
    };
    /**
     * Gets the width
     * @return {Number}
     */
    IconRow.prototype.getWidth = function () {
        return this.getValueWithColumnName(this.getWidthColumn().name);
    };
    /**
     * Sets the width for the row
     * @param {Number} width width
     */
    IconRow.prototype.setWidth = function (width) {
        this.setValueWithColumnName(this.getWidthColumn().name, width);
    };
    /**
     * Get the width or derived width from the icon data and scaled as needed
     * for the height
     *
     * @return {Number}  derived width
     */
    IconRow.prototype.getDerivedWidth = function () {
        var width = this.getWidth();
        if (width === undefined || width === null) {
            width = this.getDerivedDimensions()[0];
        }
        return width;
    };
    /**
     * Get the height column
     * @return {module:user/userColumn~UserColumn}
     */
    IconRow.prototype.getHeightColumn = function () {
        return this.iconTable.getHeightColumn();
    };
    /**
     * Gets the height
     * @return {Number}
     */
    IconRow.prototype.getHeight = function () {
        return this.getValueWithColumnName(this.getHeightColumn().name);
    };
    /**
     * Sets the height for the row
     * @param {Number} height height
     */
    IconRow.prototype.setHeight = function (height) {
        this.setValueWithColumnName(this.getHeightColumn().name, height);
    };
    /**
     * Get the height or derived height from the icon data and scaled as needed
     * for the width
     *
     * @return {Number} derived height
     */
    IconRow.prototype.getDerivedHeight = function () {
        var height = this.getHeight();
        if (height === undefined || height === null) {
            height = this.getDerivedDimensions()[1];
        }
        return height;
    };
    /**
     * Get the derived width and height from the values and icon data, scaled as needed
     * @return {Number[]} derived dimensions array with two values, width at index 0, height at index 1
     */
    IconRow.prototype.getDerivedDimensions = function () {
        var width = this.getWidth();
        var height = this.getHeight();
        if (width === undefined || width === null || height === undefined || height === null) {
            var imageSize = imageUtils_1.ImageUtils.getImageSize(this.getData());
            var dataWidth = imageSize.width;
            var dataHeight = imageSize.height;
            if (width === undefined || width === null) {
                width = dataWidth;
                if (height !== undefined && height !== null) {
                    width *= height / dataHeight;
                }
            }
            if (height === undefined || height === null) {
                height = dataHeight;
                if (width !== undefined && width !== null) {
                    height *= width / dataWidth;
                }
            }
        }
        return [width, height];
    };
    /**
     * Get the anchor_u column
     * @return {module:user/userColumn~UserColumn}
     */
    IconRow.prototype.getAnchorUColumn = function () {
        return this.iconTable.getAnchorUColumn();
    };
    /**
     * Gets the anchor_u
     * @return {Number}
     */
    IconRow.prototype.getAnchorU = function () {
        return this.getValueWithColumnName(this.getAnchorUColumn().name);
    };
    /**
     * Sets the anchor_u for the row
     * @param {Number} anchor_u anchor_u
     */
    IconRow.prototype.setAnchorU = function (anchorU) {
        this.validateAnchor(anchorU);
        this.setValueWithColumnName(this.getAnchorUColumn().name, anchorU);
    };
    /**
     * Get the anchor u value or the default value of 0.5
     * @return {Number} anchor u value
     */
    IconRow.prototype.getAnchorUOrDefault = function () {
        var anchorU = this.getAnchorU();
        if (anchorU == null) {
            anchorU = 0.5;
        }
        return anchorU;
    };
    /**
     * Get the anchor_v column
     * @return {module:user/userColumn~UserColumn}
     */
    IconRow.prototype.getAnchorVColumn = function () {
        return this.iconTable.getAnchorVColumn();
    };
    /**
     * Gets the anchor_v
     * @return {Number}
     */
    IconRow.prototype.getAnchorV = function () {
        return this.getValueWithColumnName(this.getAnchorVColumn().name);
    };
    /**
     * Sets the anchor_v for the row
     * @param {Number} anchor_v anchor_v
     */
    IconRow.prototype.setAnchorV = function (anchorV) {
        this.validateAnchor(anchorV);
        this.setValueWithColumnName(this.getAnchorVColumn().name, anchorV);
    };
    /**
     * Get the anchor v value or the default value of 1.0
     * @return {Number} anchor v value
     */
    IconRow.prototype.getAnchorVOrDefault = function () {
        var anchorV = this.getAnchorV();
        if (anchorV == null) {
            anchorV = 1.0;
        }
        return anchorV;
    };
    /**
     * Validate the anchor value
     * @param {Number} anchor anchor
     */
    IconRow.prototype.validateAnchor = function (anchor) {
        if (anchor != null && (anchor < 0.0 || anchor > 1.0)) {
            throw new Error('Anchor must be set inclusively between 0.0 and 1.0, invalid value: ' + anchor);
        }
        return true;
    };
    return IconRow;
}(mediaRow_1.MediaRow));
exports.IconRow = IconRow;
//# sourceMappingURL=iconRow.js.map