"use strict";
/**
 * @memberOf module:extension/style
 * @class IconTable
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var mediaTable_1 = require("../relatedTables/mediaTable");
var userCustomColumn_1 = require("../../user/custom/userCustomColumn");
var dataTypes_1 = require("../../db/dataTypes");
/**
 * Icon Requirements Class Media Table
 * @class
 * @extends {MediaTable}
 * @param  {string} tableName table name
 * @param  {module:user/userColumn~UserColumn[]} columns   media columns
 * @param {string[]} requiredColumns required column names
 */
var IconTable = /** @class */ (function (_super) {
    __extends(IconTable, _super);
    function IconTable() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.TABLE_TYPE = 'media';
        return _this;
    }
    /**
     * Get the name column index
     * @return int
     */
    IconTable.prototype.getNameColumnIndex = function () {
        return this.getColumnIndex(IconTable.COLUMN_NAME);
    };
    /**
     * Get the name column
     * @return {module:user/userColumn~UserColumn}
     */
    IconTable.prototype.getNameColumn = function () {
        return this.getColumnWithColumnName(IconTable.COLUMN_NAME);
    };
    /**
     * Get the description column index
     * @return int
     */
    IconTable.prototype.getDescriptionColumnIndex = function () {
        return this.getColumnIndex(IconTable.COLUMN_DESCRIPTION);
    };
    /**
     * Get the description column
     * @return {module:user/userColumn~UserColumn}
     */
    IconTable.prototype.getDescriptionColumn = function () {
        return this.getColumnWithColumnName(IconTable.COLUMN_DESCRIPTION);
    };
    /**
     * Get the width column index
     * @return int
     */
    IconTable.prototype.getWidthColumnIndex = function () {
        return this.getColumnIndex(IconTable.COLUMN_WIDTH);
    };
    /**
     * Get the width column
     * @return {module:user/userColumn~UserColumn}
     */
    IconTable.prototype.getWidthColumn = function () {
        return this.getColumnWithColumnName(IconTable.COLUMN_WIDTH);
    };
    /**
     * Get the height column index
     * @return int
     */
    IconTable.prototype.getHeightColumnIndex = function () {
        return this.getColumnIndex(IconTable.COLUMN_HEIGHT);
    };
    /**
     * Get the height column
     * @return {module:user/userColumn~UserColumn}
     */
    IconTable.prototype.getHeightColumn = function () {
        return this.getColumnWithColumnName(IconTable.COLUMN_HEIGHT);
    };
    /**
     * Get the anchor_u column index
     * @return int
     */
    IconTable.prototype.getAnchorUColumnIndex = function () {
        return this.getColumnIndex(IconTable.COLUMN_ANCHOR_U);
    };
    /**
     * Get the anchor_u column
     * @return {module:user/userColumn~UserColumn}
     */
    IconTable.prototype.getAnchorUColumn = function () {
        return this.getColumnWithColumnName(IconTable.COLUMN_ANCHOR_U);
    };
    /**
     * Get the anchor_v column index
     * @return int
     */
    IconTable.prototype.getAnchorVColumnIndex = function () {
        return this.getColumnIndex(IconTable.COLUMN_ANCHOR_V);
    };
    /**
     * Get the anchor_v column
     * @return {module:user/userColumn~UserColumn}
     */
    IconTable.prototype.getAnchorVColumn = function () {
        return this.getColumnWithColumnName(IconTable.COLUMN_ANCHOR_V);
    };
    /**
     * Create a media table with a minimum required columns followed by the additional columns
     * @return {module:extension/relatedTables~MediaTable}
     */
    IconTable.create = function () {
        return new IconTable(IconTable.TABLE_NAME, IconTable.createColumns(), IconTable.requiredColumns());
    };
    IconTable.createRequiredColumns = function () {
        return mediaTable_1.MediaTable.createRequiredColumns();
    };
    /**
     * Get the required columns
     * @return {string[]}
     */
    IconTable.requiredColumns = function () {
        return mediaTable_1.MediaTable.requiredColumns();
    };
    /**
     * Create the columns
     * @return {module:user/userColumn~UserColumn[]}
     */
    IconTable.createColumns = function () {
        var columns = IconTable.createRequiredColumns();
        var index = columns.length;
        columns.push(userCustomColumn_1.UserCustomColumn.createColumn(index++, IconTable.COLUMN_NAME, dataTypes_1.DataTypes.TEXT, undefined, false, undefined));
        columns.push(userCustomColumn_1.UserCustomColumn.createColumn(index++, IconTable.COLUMN_DESCRIPTION, dataTypes_1.DataTypes.TEXT, undefined, false, undefined));
        columns.push(userCustomColumn_1.UserCustomColumn.createColumn(index++, IconTable.COLUMN_WIDTH, dataTypes_1.DataTypes.REAL, undefined, false, undefined));
        columns.push(userCustomColumn_1.UserCustomColumn.createColumn(index++, IconTable.COLUMN_HEIGHT, dataTypes_1.DataTypes.REAL, undefined, false, undefined));
        columns.push(userCustomColumn_1.UserCustomColumn.createColumn(index++, IconTable.COLUMN_ANCHOR_U, dataTypes_1.DataTypes.REAL, undefined, false, undefined));
        columns.push(userCustomColumn_1.UserCustomColumn.createColumn(index, IconTable.COLUMN_ANCHOR_V, dataTypes_1.DataTypes.REAL, undefined, false, undefined));
        return columns;
    };
    IconTable.TABLE_NAME = 'nga_icon';
    IconTable.COLUMN_NAME = 'name';
    IconTable.COLUMN_DESCRIPTION = 'description';
    IconTable.COLUMN_WIDTH = 'width';
    IconTable.COLUMN_HEIGHT = 'height';
    IconTable.COLUMN_ANCHOR_U = 'anchor_u';
    IconTable.COLUMN_ANCHOR_V = 'anchor_v';
    return IconTable;
}(mediaTable_1.MediaTable));
exports.IconTable = IconTable;
//# sourceMappingURL=iconTable.js.map