/**
 * @memberOf module:extension/style
 * @class StyleMappingRow
 */
import { UserMappingRow } from '../relatedTables/userMappingRow';
import { StyleMappingTable } from './styleMappingTable';
import { UserColumn } from '../../user/userColumn';
import { DBValue } from '../../db/dbAdapter';
import { DataTypes } from '../../db/dataTypes';
/**
 * User Mapping Row containing the values from a single result set row
 * @extends UserMappingRow
 * @param  {module:extension/style.StyleMappingTable} styleMappingTable style mapping table
 * @param  {module:db/dataTypes[]} columnTypes  column types
 * @param  {module:dao/columnValues~ColumnValues[]} values      values
 * @constructor
 */
export declare class StyleMappingRow extends UserMappingRow {
    styleMappingTable: StyleMappingTable;
    constructor(styleMappingTable: StyleMappingTable, columnTypes?: {
        [key: string]: DataTypes;
    }, values?: Record<string, DBValue>);
    /**
     * Get the geometry type name column
     * @return {module:user/userColumn~UserColumn}
     */
    getGeometryTypeNameColumn(): UserColumn;
    /**
     * Gets the geometry type name
     * @return {string}
     */
    getGeometryTypeName(): string;
    /**
     * Sets the geometry type name
     * @param  {string} geometryTypeName geometry type name
     */
    setGeometryTypeName(geometryTypeName: string): void;
}
