"use strict";
/**
 * @memberOf module:extension/style
 * @class StyleMappingTable
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var userMappingTable_1 = require("../relatedTables/userMappingTable");
var userCustomColumn_1 = require("../../user/custom/userCustomColumn");
var dataTypes_1 = require("../../db/dataTypes");
/**
 * Contains style mapping table factory and utility methods
 * @extends UserMappingTable
 * @param  {string} tableName table name
 * @param  {module:user/userColumn~UserColumn[]} columns   style mapping columns
 * @constructor
 */
var StyleMappingTable = /** @class */ (function (_super) {
    __extends(StyleMappingTable, _super);
    function StyleMappingTable() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Get the geometry type name column index
     * @return int
     */
    StyleMappingTable.prototype.getGeometryTypeNameColumnIndex = function () {
        return this.getColumnIndex(StyleMappingTable.COLUMN_GEOMETRY_TYPE_NAME);
    };
    /**
     * Get the geometry type name column
     * @return {module:user/userColumn~UserColumn}
     */
    StyleMappingTable.prototype.getGeometryTypeNameColumn = function () {
        return this.getColumnWithColumnName(StyleMappingTable.COLUMN_GEOMETRY_TYPE_NAME);
    };
    /**
     * Creates a user mapping table with the minimum required columns followed by the additional columns
     * @param  {string} tableName name of the table
     * @return {module:extension/relatedTables~UserMappingTable}
     */
    StyleMappingTable.create = function (tableName) {
        return new StyleMappingTable(tableName, StyleMappingTable.createColumns());
    };
    /**
     * Create the columns
     * @return {module:user/userColumn~UserColumn[]}
     */
    StyleMappingTable.createColumns = function () {
        var columns = userMappingTable_1.UserMappingTable.createRequiredColumns();
        var index = columns.length;
        columns.push(userCustomColumn_1.UserCustomColumn.createColumn(index, StyleMappingTable.COLUMN_GEOMETRY_TYPE_NAME, dataTypes_1.DataTypes.TEXT, undefined, false, undefined));
        return columns;
    };
    StyleMappingTable.COLUMN_GEOMETRY_TYPE_NAME = 'geometry_type_name';
    return StyleMappingTable;
}(userMappingTable_1.UserMappingTable));
exports.StyleMappingTable = StyleMappingTable;
//# sourceMappingURL=styleMappingTable.js.map