/**
 * @memberOf module:extension/style
 * @class StyleTable
 */
import { AttributeTable } from '../../attributes/attributeTable';
import { UserColumn } from '../../user/userColumn';
import { UserCustomColumn } from '../../user/custom/userCustomColumn';
/**
 * Icon Requirements Class Media Table
 * @param  {string} tableName table name
 * @param  {module:user/userColumn~UserColumn[]} columns   media columns
 * @constructor
 */
export declare class StyleTable extends AttributeTable {
    static readonly TABLE_NAME: string;
    static readonly COLUMN_ID: string;
    static readonly COLUMN_NAME: string;
    static readonly COLUMN_DESCRIPTION: string;
    static readonly COLUMN_COLOR: string;
    static readonly COLUMN_OPACITY: string;
    static readonly COLUMN_WIDTH: string;
    static readonly COLUMN_FILL_COLOR: string;
    static readonly COLUMN_FILL_OPACITY: string;
    readonly TABLE_TYPE: string;
    data_type: string;
    relation_name: string;
    constructor(tableName: string, columns: UserCustomColumn[]);
    /**
     * Get the name column index
     * @return int
     */
    getNameColumnIndex(): number;
    /**
     * Get the name column
     * @return {module:user/userColumn~UserColumn}
     */
    getNameColumn(): UserColumn;
    /**
     * Get the description column index
     * @return int
     */
    getDescriptionColumnIndex(): number;
    /**
     * Get the description column
     * @return {module:user/userColumn~UserColumn}
     */
    getDescriptionColumn(): UserColumn;
    /**
     * Get the color column index
     * @return int
     */
    getColorColumnIndex(): number;
    /**
     * Get the color column
     * @return {module:user/userColumn~UserColumn}
     */
    getColorColumn(): UserColumn;
    /**
     * Get the opacity column index
     * @return int
     */
    getOpacityColumnIndex(): number;
    /**
     * Get the opacity column
     * @return {module:user/userColumn~UserColumn}
     */
    getOpacityColumn(): UserColumn;
    /**
     * Get the width column index
     * @return int
     */
    getWidthColumnIndex(): number;
    /**
     * Get the width column
     * @return {module:user/userColumn~UserColumn}
     */
    getWidthColumn(): UserColumn;
    /**
     * Get the fill_color column index
     * @return int
     */
    getFillColorColumnIndex(): number;
    /**
     * Get the fill_color column
     * @return {module:user/userColumn~UserColumn}
     */
    getFillColorColumn(): UserColumn;
    /**
     * Get the fill_opacity column index
     * @return int
     */
    getFillOpacityColumnIndex(): number;
    /**
     * Get the fill_opacity column
     * @return {module:user/userColumn~UserColumn}
     */
    getFillOpacityColumn(): UserColumn;
    /**
     * Create a media table with a minimum required columns followed by the additional columns
     * @return {module:extension/style.StyleTable}
     */
    static create(): StyleTable;
    /**
     * Create the columns
     * @return {module:user/custom~UserCustomColumn[]}
     */
    static createColumns(): UserCustomColumn[];
}
