"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @memberOf module:extension/style
 * @class StyleTable
 */
var attributeTable_1 = require("../../attributes/attributeTable");
var relationType_1 = require("../relatedTables/relationType");
var userColumn_1 = require("../../user/userColumn");
var userCustomColumn_1 = require("../../user/custom/userCustomColumn");
var dataTypes_1 = require("../../db/dataTypes");
/**
 * Icon Requirements Class Media Table
 * @param  {string} tableName table name
 * @param  {module:user/userColumn~UserColumn[]} columns   media columns
 * @constructor
 */
var StyleTable = /** @class */ (function (_super) {
    __extends(StyleTable, _super);
    function StyleTable(tableName, columns) {
        var _this = _super.call(this, tableName, columns) || this;
        _this.TABLE_TYPE = 'media';
        _this.data_type = relationType_1.RelationType.ATTRIBUTES.dataType;
        _this.relation_name = relationType_1.RelationType.ATTRIBUTES.name;
        return _this;
    }
    /**
     * Get the name column index
     * @return int
     */
    StyleTable.prototype.getNameColumnIndex = function () {
        return this.getColumnIndex(StyleTable.COLUMN_NAME);
    };
    /**
     * Get the name column
     * @return {module:user/userColumn~UserColumn}
     */
    StyleTable.prototype.getNameColumn = function () {
        return this.getColumnWithColumnName(StyleTable.COLUMN_NAME);
    };
    /**
     * Get the description column index
     * @return int
     */
    StyleTable.prototype.getDescriptionColumnIndex = function () {
        return this.getColumnIndex(StyleTable.COLUMN_DESCRIPTION);
    };
    /**
     * Get the description column
     * @return {module:user/userColumn~UserColumn}
     */
    StyleTable.prototype.getDescriptionColumn = function () {
        return this.getColumnWithColumnName(StyleTable.COLUMN_DESCRIPTION);
    };
    /**
     * Get the color column index
     * @return int
     */
    StyleTable.prototype.getColorColumnIndex = function () {
        return this.getColumnIndex(StyleTable.COLUMN_COLOR);
    };
    /**
     * Get the color column
     * @return {module:user/userColumn~UserColumn}
     */
    StyleTable.prototype.getColorColumn = function () {
        return this.getColumnWithColumnName(StyleTable.COLUMN_COLOR);
    };
    /**
     * Get the opacity column index
     * @return int
     */
    StyleTable.prototype.getOpacityColumnIndex = function () {
        return this.getColumnIndex(StyleTable.COLUMN_OPACITY);
    };
    /**
     * Get the opacity column
     * @return {module:user/userColumn~UserColumn}
     */
    StyleTable.prototype.getOpacityColumn = function () {
        return this.getColumnWithColumnName(StyleTable.COLUMN_OPACITY);
    };
    /**
     * Get the width column index
     * @return int
     */
    StyleTable.prototype.getWidthColumnIndex = function () {
        return this.getColumnIndex(StyleTable.COLUMN_WIDTH);
    };
    /**
     * Get the width column
     * @return {module:user/userColumn~UserColumn}
     */
    StyleTable.prototype.getWidthColumn = function () {
        return this.getColumnWithColumnName(StyleTable.COLUMN_WIDTH);
    };
    /**
     * Get the fill_color column index
     * @return int
     */
    StyleTable.prototype.getFillColorColumnIndex = function () {
        return this.getColumnIndex(StyleTable.COLUMN_FILL_COLOR);
    };
    /**
     * Get the fill_color column
     * @return {module:user/userColumn~UserColumn}
     */
    StyleTable.prototype.getFillColorColumn = function () {
        return this.getColumnWithColumnName(StyleTable.COLUMN_FILL_COLOR);
    };
    /**
     * Get the fill_opacity column index
     * @return int
     */
    StyleTable.prototype.getFillOpacityColumnIndex = function () {
        return this.getColumnIndex(StyleTable.COLUMN_FILL_OPACITY);
    };
    /**
     * Get the fill_opacity column
     * @return {module:user/userColumn~UserColumn}
     */
    StyleTable.prototype.getFillOpacityColumn = function () {
        return this.getColumnWithColumnName(StyleTable.COLUMN_FILL_OPACITY);
    };
    /**
     * Create a media table with a minimum required columns followed by the additional columns
     * @return {module:extension/style.StyleTable}
     */
    StyleTable.create = function () {
        return new StyleTable(StyleTable.TABLE_NAME, StyleTable.createColumns());
    };
    /**
     * Create the columns
     * @return {module:user/custom~UserCustomColumn[]}
     */
    StyleTable.createColumns = function () {
        var columns = [];
        var index = 0;
        columns.push(userColumn_1.UserColumn.createPrimaryKeyColumnWithIndexAndName(index++, StyleTable.COLUMN_ID));
        columns.push(userCustomColumn_1.UserCustomColumn.createColumn(index++, StyleTable.COLUMN_NAME, dataTypes_1.DataTypes.TEXT, undefined, false, undefined));
        columns.push(userCustomColumn_1.UserCustomColumn.createColumn(index++, StyleTable.COLUMN_DESCRIPTION, dataTypes_1.DataTypes.TEXT, undefined, false, undefined));
        columns.push(userCustomColumn_1.UserCustomColumn.createColumn(index++, StyleTable.COLUMN_COLOR, dataTypes_1.DataTypes.TEXT, undefined, false, undefined));
        columns.push(userCustomColumn_1.UserCustomColumn.createColumn(index++, StyleTable.COLUMN_OPACITY, dataTypes_1.DataTypes.REAL, undefined, false, undefined));
        columns.push(userCustomColumn_1.UserCustomColumn.createColumn(index++, StyleTable.COLUMN_WIDTH, dataTypes_1.DataTypes.REAL, undefined, false, undefined));
        columns.push(userCustomColumn_1.UserCustomColumn.createColumn(index++, StyleTable.COLUMN_FILL_COLOR, dataTypes_1.DataTypes.TEXT, undefined, false, undefined));
        columns.push(userCustomColumn_1.UserCustomColumn.createColumn(index, StyleTable.COLUMN_FILL_OPACITY, dataTypes_1.DataTypes.REAL, undefined, false, undefined));
        return columns;
    };
    StyleTable.TABLE_NAME = 'nga_style';
    StyleTable.COLUMN_ID = 'id';
    StyleTable.COLUMN_NAME = 'name';
    StyleTable.COLUMN_DESCRIPTION = 'description';
    StyleTable.COLUMN_COLOR = 'color';
    StyleTable.COLUMN_OPACITY = 'opacity';
    StyleTable.COLUMN_WIDTH = 'width';
    StyleTable.COLUMN_FILL_COLOR = 'fill_color';
    StyleTable.COLUMN_FILL_OPACITY = 'fill_opacity';
    return StyleTable;
}(attributeTable_1.AttributeTable));
exports.StyleTable = StyleTable;
//# sourceMappingURL=styleTable.js.map