/// <reference types="proj4" />
/**
 * GeometryColumns module.
 * @module features/columns
 */
import { Dao } from '../../dao/dao';
import { GeometryColumns } from './geometryColumns';
import { SpatialReferenceSystem } from '../../core/srs/spatialReferenceSystem';
import { Contents } from '../../core/contents/contents';
import { DBValue } from '../../db/dbAdapter';
/**
 * Geometry Columns Data Access Object
 * @class GeometryColumnsDao
 * @extends Dao
 */
export declare class GeometryColumnsDao extends Dao<GeometryColumns> {
    /**
     * tableName field name
     * @type {String}
     */
    static readonly COLUMN_TABLE_NAME: string;
    /**
     * columnName field name
     * @type {String}
     */
    static readonly COLUMN_COLUMN_NAME: string;
    /**
     * id 1 field name, tableName
     * @type {String}
     */
    static readonly COLUMN_ID_1: string;
    /**
     * id 2 field name, columnName
     * @type {String}
     */
    static readonly COLUMN_ID_2: string;
    /**
     * geometryTypeName field name
     * @type {String}
     */
    static readonly COLUMN_GEOMETRY_TYPE_NAME: string;
    /**
     * srsId field name
     * @type {String}
     */
    static readonly COLUMN_SRS_ID: string;
    /**
     * z field name
     * @type {String}
     */
    static readonly COLUMN_Z: string;
    /**
     * m field name
     * @type {String}
     */
    static readonly COLUMN_M: string;
    /**
     * Table Name
     * @type {String}
     */
    readonly gpkgTableName: string;
    readonly idColumns: string[];
    readonly columns: string[];
    createObject(results?: Record<string, DBValue>): GeometryColumns;
    /**
     *  Query for the table name
     *
     *  @param {string} tableName table name
     */
    queryForTableName(tableName: string): GeometryColumns;
    /**
     *  Get the feature table names
     * @returns {String []} feature table names
     */
    getFeatureTables(): string[];
    /**
     *  Get the Spatial Reference System of the Geometry Columns
     *
     *  @param {module:dao/geometryColumns~GeometryColumns} geometryColumns geometry columns
     */
    getSrs(geometryColumns: GeometryColumns): SpatialReferenceSystem;
    /**
     *  Get the Contents of the Geometry Columns
     *
     *  @param {module:dao/geometryColumns~GeometryColumns} geometryColumns geometry columns
     *  @return {ContentsDao} contents dao
     */
    getContents(geometryColumns: GeometryColumns): Contents;
    getProjection(projectionObject: GeometryColumns): proj4.Converter;
}
