"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
/* eslint-disable camelcase */
/**
 * GeometryColumns module.
 * @module features/columns
 */
var dao_1 = require("../../dao/dao");
var geometryColumns_1 = require("./geometryColumns");
/**
 * Geometry Columns Data Access Object
 * @class GeometryColumnsDao
 * @extends Dao
 */
var GeometryColumnsDao = /** @class */ (function (_super) {
    __extends(GeometryColumnsDao, _super);
    function GeometryColumnsDao() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * Table Name
         * @type {String}
         */
        _this.gpkgTableName = 'gpkg_geometry_columns';
        _this.idColumns = [GeometryColumnsDao.COLUMN_ID_1, GeometryColumnsDao.COLUMN_ID_2];
        _this.columns = [
            GeometryColumnsDao.COLUMN_TABLE_NAME,
            GeometryColumnsDao.COLUMN_COLUMN_NAME,
            GeometryColumnsDao.COLUMN_GEOMETRY_TYPE_NAME,
            GeometryColumnsDao.COLUMN_SRS_ID,
            GeometryColumnsDao.COLUMN_Z,
            GeometryColumnsDao.COLUMN_M,
        ];
        return _this;
    }
    GeometryColumnsDao.prototype.createObject = function (results) {
        var gc = new geometryColumns_1.GeometryColumns();
        if (results) {
            gc.table_name = results.table_name;
            gc.column_name = results.column_name;
            gc.geometry_type_name = results.geometry_type_name;
            gc.srs_id = results.srs_id;
            gc.z = results.z;
            gc.m = results.m;
        }
        return gc;
    };
    /**
     *  Query for the table name
     *
     *  @param {string} tableName table name
     */
    GeometryColumnsDao.prototype.queryForTableName = function (tableName) {
        var results = this.queryForAllEq(GeometryColumnsDao.COLUMN_TABLE_NAME, tableName);
        if (results && results.length) {
            return this.createObject(results[0]);
        }
        return;
    };
    /**
     *  Get the feature table names
     * @returns {String []} feature table names
     */
    GeometryColumnsDao.prototype.getFeatureTables = function () {
        var e_1, _a;
        var tableNames = [];
        try {
            for (var _b = __values(this.connection.each('select ' + GeometryColumnsDao.COLUMN_TABLE_NAME + ' from ' + this.gpkgTableName)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var result = _c.value;
                tableNames.push(result[GeometryColumnsDao.COLUMN_TABLE_NAME]);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return tableNames;
    };
    /**
     *  Get the Spatial Reference System of the Geometry Columns
     *
     *  @param {module:dao/geometryColumns~GeometryColumns} geometryColumns geometry columns
     */
    GeometryColumnsDao.prototype.getSrs = function (geometryColumns) {
        return this.geoPackage.spatialReferenceSystemDao.queryForId(geometryColumns.srs_id);
    };
    /**
     *  Get the Contents of the Geometry Columns
     *
     *  @param {module:dao/geometryColumns~GeometryColumns} geometryColumns geometry columns
     *  @return {ContentsDao} contents dao
     */
    GeometryColumnsDao.prototype.getContents = function (geometryColumns) {
        return this.geoPackage.contentsDao.queryForId(geometryColumns.table_name);
    };
    GeometryColumnsDao.prototype.getProjection = function (projectionObject) {
        var srs = this.getSrs(projectionObject);
        return this.geoPackage.spatialReferenceSystemDao.getProjection(srs);
    };
    /**
     * tableName field name
     * @type {String}
     */
    GeometryColumnsDao.COLUMN_TABLE_NAME = 'table_name';
    /**
     * columnName field name
     * @type {String}
     */
    GeometryColumnsDao.COLUMN_COLUMN_NAME = 'column_name';
    /**
     * id 1 field name, tableName
     * @type {String}
     */
    GeometryColumnsDao.COLUMN_ID_1 = GeometryColumnsDao.COLUMN_TABLE_NAME;
    /**
     * id 2 field name, columnName
     * @type {String}
     */
    GeometryColumnsDao.COLUMN_ID_2 = GeometryColumnsDao.COLUMN_COLUMN_NAME;
    /**
     * geometryTypeName field name
     * @type {String}
     */
    GeometryColumnsDao.COLUMN_GEOMETRY_TYPE_NAME = 'geometry_type_name';
    /**
     * srsId field name
     * @type {String}
     */
    GeometryColumnsDao.COLUMN_SRS_ID = 'srs_id';
    /**
     * z field name
     * @type {String}
     */
    GeometryColumnsDao.COLUMN_Z = 'z';
    /**
     * m field name
     * @type {String}
     */
    GeometryColumnsDao.COLUMN_M = 'm';
    return GeometryColumnsDao;
}(dao_1.Dao));
exports.GeometryColumnsDao = GeometryColumnsDao;
//# sourceMappingURL=geometryColumnsDao.js.map