/**
 * @module features/user/featureColumn
 */
import { UserColumn } from '../../user/userColumn';
import { DataTypes } from '../../db/dataTypes';
import { DBValue } from '../../db/dbAdapter';
/**
 * Represents a user feature column
 * @class
 * @extends UserColumn
 */
export declare class FeatureColumn extends UserColumn {
    geometryType: any;
    constructor(index: number, name: string, dataType: any, max?: number, notNull?: boolean, defaultValue?: any, primaryKey?: boolean, geometryType?: any);
    getTypeName(): string;
    /**
     * Determine if this column is a geometry
     * @return {Boolean} true if a geometry column
     */
    isGeometry(): boolean;
    /**
     *  Create a new primary key column
     *
     *  @param {Number} index column index
     *  @param {string} name  column name
     *
     *  @return feature column
     */
    static createPrimaryKeyColumnWithIndexAndName(index: number, name: string): FeatureColumn;
    /**
     *  Create a new geometry column
     *
     *  @param {Number} index        column index
     *  @param {string} name         column name
     *  @param {String} type         geometry type
     *  @param {Boolean} notNull      not null
     *  @param {Object} defaultValue default value or nil
     *
     *  @return feature column
     */
    static createGeometryColumn(index: number, name: string, type: string, notNull: boolean, defaultValue?: DBValue): FeatureColumn;
    /**
     *  Create a new column
     *
     *  @param {Number} index        column index
     *  @param {string} name         column name
     *  @param {module:db/dataTypes~GPKGDataType} type         data type
     *  @param {Boolean} notNull      not null
     *  @param {Object} defaultValue default value or nil
     *  @param {Number} max max value
     *  @return feature column
     */
    static createColumn(index: number, name: string, type: DataTypes, notNull?: boolean, defaultValue?: DBValue, max?: number): FeatureColumn;
}
