"use strict";
/**
 * @module features/user/featureColumn
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var userColumn_1 = require("../../user/userColumn");
var dataTypes_1 = require("../../db/dataTypes");
/**
 * Represents a user feature column
 * @class
 * @extends UserColumn
 */
var FeatureColumn = /** @class */ (function (_super) {
    __extends(FeatureColumn, _super);
    function FeatureColumn(index, name, dataType, max, notNull, defaultValue, primaryKey, geometryType) {
        var _this = _super.call(this, index, name, dataType, max, notNull, defaultValue, primaryKey) || this;
        _this.geometryType = geometryType;
        if (!geometryType && dataType === dataTypes_1.DataTypes.GEOMETRY) {
            throw new Error('Data or Geometry Type is required to create column: ' + name);
        }
        return _this;
    }
    FeatureColumn.prototype.getTypeName = function () {
        if (this.isGeometry()) {
            return dataTypes_1.DataTypes.nameFromType(dataTypes_1.DataTypes.GEOMETRY);
        }
        return this.dataType !== undefined && dataTypes_1.DataTypes.nameFromType(this.dataType);
    };
    /**
     * Determine if this column is a geometry
     * @return {Boolean} true if a geometry column
     */
    FeatureColumn.prototype.isGeometry = function () {
        return this.geometryType !== undefined;
    };
    /**
     *  Create a new primary key column
     *
     *  @param {Number} index column index
     *  @param {string} name  column name
     *
     *  @return feature column
     */
    FeatureColumn.createPrimaryKeyColumnWithIndexAndName = function (index, name) {
        return new FeatureColumn(index, name, dataTypes_1.DataTypes.INTEGER, undefined, true, undefined, true);
    };
    /**
     *  Create a new geometry column
     *
     *  @param {Number} index        column index
     *  @param {string} name         column name
     *  @param {String} type         geometry type
     *  @param {Boolean} notNull      not null
     *  @param {Object} defaultValue default value or nil
     *
     *  @return feature column
     */
    FeatureColumn.createGeometryColumn = function (index, name, type, notNull, defaultValue) {
        return new FeatureColumn(index, name, type, undefined, notNull, defaultValue, false, type);
    };
    /**
     *  Create a new column
     *
     *  @param {Number} index        column index
     *  @param {string} name         column name
     *  @param {module:db/dataTypes~GPKGDataType} type         data type
     *  @param {Boolean} notNull      not null
     *  @param {Object} defaultValue default value or nil
     *  @param {Number} max max value
     *  @return feature column
     */
    FeatureColumn.createColumn = function (index, name, type, notNull, defaultValue, max) {
        if (notNull === void 0) { notNull = false; }
        return new FeatureColumn(index, name, type, max, notNull, defaultValue, false);
    };
    return FeatureColumn;
}(userColumn_1.UserColumn));
exports.FeatureColumn = FeatureColumn;
//# sourceMappingURL=featureColumn.js.map