import { FeatureTable } from './featureTable';
import { UserRow } from '../../user/userRow';
import { FeatureColumn } from './featureColumn';
import { DataTypes } from '../../db/dataTypes';
import { GeometryData } from '../../geom/geometryData';
import { DBValue } from '../../db/dbAdapter';
/**
 * featureRow module.
 * @module features/user/featureRow
 */
/**
 * Feature Row containing the values from a single result set row
 * @param  {FeatureTable} featureTable feature table
 * @param  {Array} columnTypes  column types
 * @param  {Array} values       values
 */
export declare class FeatureRow extends UserRow {
    featureTable: FeatureTable;
    constructor(featureTable: FeatureTable, columnTypes?: {
        [key: string]: DataTypes;
    }, values?: Record<string, DBValue>);
    /**
     * Get the geometry column index
     * @return {Number} geometry column index
     */
    getGeometryColumnIndex(): number;
    /**
     * Get the geometry column
     * @return {FeatureColumn} geometry column
     */
    getGeometryColumn(): FeatureColumn;
    /**
     * Get the geometry
     * @return {Buffer} geometry data
     */
    getGeometry(): GeometryData;
    /**
     * Get the geometry's type
     * @return {String} geometry data
     */
    getGeometryType(): string;
    /**
     * set the geometry
     * @param {Buffer} geometryData geometry data
     */
    setGeometry(geometryData: GeometryData): void;
    toObjectValue(index: number, value: DBValue): object | GeometryData;
    toDatabaseValue(columnName: string): DBValue;
}
