"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * featureTable module.
 * @module features/user/featureTable
 */
var userTable_1 = require("../../user/userTable");
var featureColumn_1 = require("./featureColumn");
/**
 * Represents a user feature table
 * @param  {string} tableName table name
 * @param  {array} columns   feature columns
 */
var FeatureTable = /** @class */ (function (_super) {
    __extends(FeatureTable, _super);
    function FeatureTable(tableName, columns) {
        var _this = _super.call(this, tableName, columns) || this;
        var geometry = undefined;
        for (var i = 0; i < columns.length; i++) {
            var column = columns[i];
            if (column instanceof featureColumn_1.FeatureColumn && column.isGeometry()) {
                _this.duplicateCheck(column.index, geometry, /* WKB_GEOMETRY_NAME */ 'GEOMETRY');
                geometry = column.index;
            }
        }
        _this.missingCheck(geometry, /* WKB_GEOMETRY_NAME */ 'GEOMETRY');
        _this.geometryIndex = geometry;
        return _this;
    }
    /**
     * Get the geometry feature column
     * @return {FeatureColumn} geometry feature column
     */
    FeatureTable.prototype.getGeometryColumn = function () {
        return this.getColumnWithIndex(this.geometryIndex);
    };
    FeatureTable.prototype.getTableType = function () {
        return userTable_1.UserTable.FEATURE_TABLE;
    };
    return FeatureTable;
}(userTable_1.UserTable));
exports.FeatureTable = FeatureTable;
//# sourceMappingURL=featureTable.js.map