import { FeatureTable } from './featureTable';
import { UserTableReader } from '../../user/userTableReader';
import { FeatureColumn } from './featureColumn';
import { GeometryColumns } from '../columns/geometryColumns';
import { GeoPackage } from '../../geoPackage';
import { UserColumn } from '../../user/userColumn';
import { DBValue } from '../../db/dbAdapter';
/**
 * Reads the metadata from an existing feature table
 * @class FeatureTableReader
 */
export declare class FeatureTableReader extends UserTableReader {
    geometryColumns: GeometryColumns;
    constructor(tableNameOrGeometryColumns: string | GeometryColumns);
    readFeatureTable(geoPackage: GeoPackage): FeatureTable;
    createTable(tableName: string, columns: UserColumn[]): FeatureTable;
    createColumn(index: number, name: string, type: string, max?: number, notNull?: boolean, defaultValue?: DBValue, primaryKey?: boolean): FeatureColumn;
}
