"use strict";
/**
 * GeoPackage Constants module.
 * @module dao/geoPackageConstants
 */
Object.defineProperty(exports, "__esModule", { value: true });
var GeoPackageConstants = /** @class */ (function () {
    function GeoPackageConstants() {
    }
    /** @constant {string} GEOPACKAGE_EXTENSION Extension to GeoPackage files */
    GeoPackageConstants.GEOPACKAGE_EXTENSION = 'gpkg';
    /** @constant {string} GEOPACKAGE_EXTENDED_EXTENSION Extension to GeoPackage extension files */
    GeoPackageConstants.GEOPACKAGE_EXTENDED_EXTENSION = 'gpkx';
    /** @constant {string} APPLICATION_ID GeoPackage application id */
    GeoPackageConstants.APPLICATION_ID = 'GPKG';
    /** @constant {string} USER_VERSION GeoPackage user version */
    GeoPackageConstants.USER_VERSION = '10200';
    /** @constant {string} GEOPACKAGE_EXTENSION_AUTHOR GeoPackage author */
    GeoPackageConstants.GEOPACKAGE_EXTENSION_AUTHOR = GeoPackageConstants.GEOPACKAGE_EXTENSION;
    /** @constant {string} GEOMETRY_EXTENSION_PREFIX Geometry extension prefix */
    GeoPackageConstants.GEOMETRY_EXTENSION_PREFIX = 'geom';
    /** @constant {string} GEOPACKAGE_GEOMETRY_MAGIX_NUMBER Expected magic number */
    GeoPackageConstants.GEOPACKAGE_GEOMETRY_MAGIC_NUMBER = 'GP';
    /** @constant {string} GEOPACKAGE_GEOMETRY_VERSION_1 Expected version 1 value */
    GeoPackageConstants.GEOPACKAGE_GEOMETRY_VERSION_1 = 0;
    /** @constant {string} SQLITE_HEADER_PREFIX SQLite header string prefix */
    GeoPackageConstants.SQLITE_HEADER_PREFIX = 'SQLite format 3';
    return GeoPackageConstants;
}());
exports.GeoPackageConstants = GeoPackageConstants;
//# sourceMappingURL=geoPackageConstants.js.map