/**
 * Metadata module.
 * @module metadata
 * @see module:dao/dao
 */
import { Dao } from '../dao/dao';
import { Metadata } from './metadata';
import { DBValue } from '../db/dbAdapter';
/**
 * Metadata Data Access Object
 * @class
 * @extends Dao
 */
export declare class MetadataDao extends Dao<Metadata> {
    static readonly TABLE_NAME: string;
    static readonly COLUMN_ID: string;
    static readonly COLUMN_MD_SCOPE: string;
    static readonly COLUMN_MD_STANDARD_URI: string;
    static readonly COLUMN_MIME_TYPE: string;
    static readonly COLUMN_METADATA: string;
    readonly gpkgTableName: string;
    readonly idColumns: string[];
    createObject(results?: Record<string, DBValue>): Metadata;
}
