/**
 * MetadataReference module.
 * @module metadata/reference
 * @see module:dao/dao
 */
import { Metadata } from '../metadata';
import { DBValue } from '../../db/dbAdapter';
declare type MetadataReferenceKeys = 'reference_scope' | 'table_name' | 'column_name' | 'row_id_value' | 'timestamp' | 'md_file_id' | 'md_parent_id';
/**
 * Links metadata in the gpkg_metadata table to data in the feature, and tiles tables
 * @class MetadataReference
 */
export declare class MetadataReference {
    static readonly GEOPACKAGE: string;
    static readonly TABLE: string;
    static readonly COLUMN: string;
    static readonly ROW: string;
    static readonly ROW_COL: string;
    /**
     * Lowercase metadata reference scope; one of ‘geopackage’, ‘table’, ‘column’, ’row’, ’row/col’
     * @member {string}
     */
    reference_scope: string;
    /**
     * Name of the table to which this metadata reference applies, or NULL for reference_scope of ‘geopackage’.
     * @member {string}
     */
    table_name: string;
    /**
     * Name of the column to which this metadata reference applies; NULL for
     * reference_scope of ‘geopackage’,‘table’ or ‘row’, or the name of a column
     * in the table_name table for reference_scope of ‘column’ or ‘row/col’
     * @member {string}
     */
    column_name: string;
    /**
     * NULL for reference_scope of ‘geopackage’, ‘table’ or ‘column’, or the
     * rowed of a row record in the table_name table for reference_scope of
     * ‘row’ or ‘row/col’
     * @member {Number}
     */
    row_id_value: number;
    /**
     * timestamp value in ISO 8601 format as defined by the strftime function
     * '%Y-%m-%dT%H:%M:%fZ' format string applied to the current time
     * @member {Date}
     */
    timestamp: Date;
    /**
     * gpkg_metadata table id column value for the metadata to which this
     * gpkg_metadata_reference applies
     * @member {Number}
     */
    md_file_id: number;
    /**
     * gpkg_metadata table id column value for the hierarchical parent
     * gpkg_metadata for the gpkg_metadata to which this gpkg_metadata_reference
     * applies, or NULL if md_file_id forms the root of a metadata hierarchy
     * @member {Number}
     */
    md_parent_id: number;
    /**
     * @param {string} columnName
     */
    toDatabaseValue(columnName: MetadataReferenceKeys): DBValue;
    /**
     * Set the metadata
     * @param  {Metadata} [metadata] metadata
     */
    setMetadata(metadata?: Metadata): void;
    /**
     * Set the parent metadata
     * @param  {Metadata} [metadata] parent metadata
     */
    setParentMetadata(metadata?: Metadata): void;
    setReferenceScopeType(referenceScopeType: string): void;
}
export {};
